/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque;

import java.util.function.Predicate;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;

public record Constants() {
    public static int particleCount = 0;
    public static final int TPS = 20;
    public static final int TPM = 1200;
    public static final int TPD = 24000;
    public static Predicate<Entity> notPlayer = entity -> !(entity instanceof Player);
    public static Predicate<Entity> isCreeper = Creeper.class::isInstance;
    public static Predicate<Entity> isNotCreativeSpecPlayer = entity -> {
        Player playerEntity;
        return entity instanceof Player && !(playerEntity = (Player)entity).isCreative() && !playerEntity.isSpectator();
    };
    public static Predicate<Entity> isCreativeSpecPlayer = entity -> {
        Player playerEntity;
        return entity instanceof Player && ((playerEntity = (Player)entity).isCreative() || playerEntity.isSpectator());
    };
    public static Predicate<Entity> hasEggEffect = entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && GigEntityUtils.isTargetHostable((Entity)(livingEntity = (LivingEntity)entity)) && livingEntity.hasEffect(GigStatusEffects.EGGMORPHING);
    };
    public static Predicate<Entity> hasCureEffects = entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(GigStatusEffects.DNA) && livingEntity.hasEffect(MobEffects.ABSORPTION) && livingEntity.hasEffect(MobEffects.WITHER) && livingEntity.hasEffect(MobEffects.REGENERATION);
    };
    public static Predicate<Entity> hasDNAEffect = entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && GigEntityUtils.isTargetGooable((Entity)(livingEntity = (LivingEntity)entity)) && livingEntity.hasEffect(GigStatusEffects.DNA);
    };
    public static Predicate<Entity> hasImpEffect = entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && GigEntityUtils.isTargetHostable((Entity)(livingEntity = (LivingEntity)entity)) && livingEntity.hasEffect(GigStatusEffects.IMPREGNATION);
    };
    public static Predicate<Entity> hasSporeEffect = entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && GigEntityUtils.convertToNeo(livingEntity = (LivingEntity)entity) && livingEntity.hasEffect(GigStatusEffects.SPORE);
    };
    public static Predicate<Entity> shouldApplyImpEffects = entity -> {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && hasImpEffect.test((Entity)(livingEntity = (LivingEntity)entity)) && (double)livingEntity.getEffect(GigStatusEffects.IMPREGNATION).getDuration() < 0.2 * (double)CommonMod.config.getImpregnationTickTimer() && (long)(livingEntity.tickCount % 20) == 0L;
    };
    public static final String ATTACK_CONTROLLER = "attack_controller";
    public static final String LIVING_CONTROLLER = "livingController";
    public static final String BASE_CONTROLLER = "base_controller";
    public static final String HOSTILE_CONTROLLER = "hostile_controller";
    public static final String HISS_CONTROLLER = "hiss_controller";

    public static <T> T self(Object object) {
        return (T)object;
    }

    public static ResourceLocation modResource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"gigeresque", (String)name);
    }
}

