/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.core.v1.utility.EnvironmentAwareBuilder;
import fuzs.puzzleslib.api.init.v3.registry.ExtendedMenuSupplier;
import fuzs.puzzleslib.api.item.v2.ItemEquipmentFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.item.CreativeModeTabHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;

public interface RegistryManager
extends EnvironmentAwareBuilder<RegistryManager> {
    public static RegistryManager from(String modId) {
        return ModContext.get(modId).getRegistryManager();
    }

    default public <T> ResourceKey<T> makeResourceKey(ResourceKey<? extends Registry<? super T>> registryKey, String path) {
        return ResourceKey.create(registryKey, (ResourceLocation)this.makeKey(path));
    }

    public ResourceLocation makeKey(String var1);

    default public String makeDescriptionId(ResourceKey<? extends Registry<?>> registryKey, String path) {
        return Util.makeDescriptionId((String)Registries.elementsDirPath(registryKey), (ResourceLocation)this.makeKey(path));
    }

    public <T> Holder.Reference<T> registerLazily(ResourceKey<? extends Registry<? super T>> var1, String var2);

    public <T> Holder.Reference<T> register(ResourceKey<? extends Registry<? super T>> var1, String var2, Supplier<T> var3);

    default public Holder.Reference<Block> registerSimpleBlock(String path, Supplier<BlockBehaviour.Properties> blockPropertiesSupplier) {
        return this.registerBlock(path, Block::new, blockPropertiesSupplier);
    }

    default public Holder.Reference<Block> registerBlock(String path, Function<BlockBehaviour.Properties, Block> factory, Supplier<BlockBehaviour.Properties> blockPropertiesSupplier) {
        return this.register(Registries.BLOCK, path, () -> (Block)factory.apply((BlockBehaviour.Properties)blockPropertiesSupplier.get()));
    }

    default public Holder.Reference<Item> registerItem(String path) {
        return this.registerSimpleItem(path, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerSimpleItem(String path, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerItem(path, Item::new, itemPropertiesSupplier);
    }

    default public Holder.Reference<Item> registerItem(String path, Function<Item.Properties, Item> factory) {
        return this.registerItem(path, factory, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerItem(String path, Function<Item.Properties, Item> factory, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.register(Registries.ITEM, path, () -> (Item)factory.apply((Item.Properties)itemPropertiesSupplier.get()));
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block) {
        return this.registerBlockItem(block, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerBlockItem(block, BlockItem::new, itemPropertiesSupplier);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block, BiFunction<Block, Item.Properties, ? extends BlockItem> itemFactory) {
        return this.registerBlockItem(block, itemFactory, Item.Properties::new);
    }

    default public Holder.Reference<Item> registerBlockItem(Holder<Block> block, BiFunction<Block, Item.Properties, ? extends BlockItem> factory, Supplier<Item.Properties> itemPropertiesSupplier) {
        return this.registerItem(((ResourceKey)block.unwrapKey().orElseThrow()).location().getPath(), itemProperties -> (Item)factory.apply((Block)block.value(), (Item.Properties)itemProperties), itemPropertiesSupplier);
    }

    @Deprecated
    default public Holder.Reference<Block> registerBlock(String path, Supplier<Block> entry) {
        return this.register(Registries.BLOCK, path, entry);
    }

    @Deprecated
    default public Holder.Reference<Item> registerItem(String path, Supplier<Item> entry) {
        return this.register(Registries.ITEM, path, entry);
    }

    @Deprecated
    default public Holder.Reference<Item> registerBlockItem(Holder<Block> blockReference, Item.Properties itemProperties) {
        return this.registerBlockItem(blockReference, () -> itemProperties);
    }

    default public Holder.Reference<Item> registerSpawnEggItem(Holder<? extends EntityType<? extends Mob>> entityTypeReference, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeReference, backgroundColor, highlightColor, new Item.Properties());
    }

    public Holder.Reference<Item> registerSpawnEggItem(Holder<? extends EntityType<? extends Mob>> var1, int var2, int var3, Item.Properties var4);

    default public Holder.Reference<CreativeModeTab> registerCreativeModeTab(Holder<? extends ItemLike> iconHolder) {
        return this.registerCreativeModeTab(() -> new ItemStack((ItemLike)iconHolder.value()));
    }

    default public Holder.Reference<CreativeModeTab> registerCreativeModeTab(Supplier<ItemStack> iconSupplier) {
        return this.registerCreativeModeTab(iconSupplier, CreativeModeTabHelper.getDisplayItems(this.makeKey("main").getNamespace()));
    }

    default public Holder.Reference<CreativeModeTab> registerCreativeModeTab(Supplier<ItemStack> iconSupplier, CreativeModeTab.DisplayItemsGenerator displayItems) {
        return this.registerCreativeModeTab("main", iconSupplier, displayItems, false);
    }

    public Holder.Reference<CreativeModeTab> registerCreativeModeTab(String var1, Supplier<ItemStack> var2, CreativeModeTab.DisplayItemsGenerator var3, boolean var4);

    default public <T> Holder.Reference<DataComponentType<T>> registerDataComponentType(String path, UnaryOperator<DataComponentType.Builder<T>> entry) {
        return this.register(Registries.DATA_COMPONENT_TYPE, path, () -> ((DataComponentType.Builder)entry.apply(DataComponentType.builder())).build());
    }

    default public Holder.Reference<Fluid> registerFluid(String path, Supplier<Fluid> entry) {
        return this.register(Registries.FLUID, path, entry);
    }

    default public Holder.Reference<MobEffect> registerMobEffect(String path, Supplier<MobEffect> entry) {
        return this.register(Registries.MOB_EFFECT, path, entry);
    }

    default public Holder.Reference<SoundEvent> registerSoundEvent(String path) {
        return this.register(Registries.SOUND_EVENT, path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)this.makeKey(path)));
    }

    default public Holder.Reference<Potion> registerPotion(String path, Supplier<Potion> entry) {
        return this.register(Registries.POTION, path, entry);
    }

    default public ResourceKey<Enchantment> registerEnchantment(String path) {
        return this.makeResourceKey(Registries.ENCHANTMENT, path);
    }

    default public <T extends Entity> Holder.Reference<EntityType<T>> registerEntityType(String path, Supplier<EntityType.Builder<T>> entry) {
        return this.register(Registries.ENTITY_TYPE, path, () -> ((EntityType.Builder)entry.get()).build(path));
    }

    default public <T extends BlockEntity> Holder.Reference<BlockEntityType<T>> registerBlockEntityType(String path, Supplier<BlockEntityType.Builder<T>> entry) {
        return this.register(Registries.BLOCK_ENTITY_TYPE, path, () -> ((BlockEntityType.Builder)entry.get()).build(null));
    }

    default public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerMenuType(String path, Supplier<MenuType.MenuSupplier<T>> entry) {
        return this.register(Registries.MENU, path, () -> new MenuType((MenuType.MenuSupplier)entry.get(), FeatureFlags.DEFAULT_FLAGS));
    }

    public <T extends AbstractContainerMenu> Holder.Reference<MenuType<T>> registerExtendedMenuType(String var1, Supplier<ExtendedMenuSupplier<T>> var2);

    default public Holder.Reference<PoiType> registerPoiType(String path, Holder<Block> block) {
        return this.registerPoiType(path, () -> block.value());
    }

    default public Holder.Reference<PoiType> registerPoiType(String path, Supplier<Block> block) {
        return this.registerPoiType(path, () -> ImmutableSet.copyOf((Collection)((Block)block.get()).getStateDefinition().getPossibleStates()), 0, 1);
    }

    public Holder.Reference<PoiType> registerPoiType(String var1, Supplier<Set<BlockState>> var2, int var3, int var4);

    default public <A extends ArgumentType<?>> Holder.Reference<ArgumentTypeInfo<?, ?>> registerArgumentType(String path, Class<? extends A> argumentClass, Supplier<A> argumentType) {
        return this.registerArgumentType(path, argumentClass, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(argumentType));
    }

    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> Holder.Reference<ArgumentTypeInfo<?, ?>> registerArgumentType(String var1, Class<? extends A> var2, ArgumentTypeInfo<A, T> var3);

    default public <T extends Recipe<?>> Holder.Reference<RecipeType<T>> registerRecipeType(String path) {
        return this.register(Registries.RECIPE_TYPE, path, () -> {
            final ResourceLocation resourceLocation = this.makeKey(path);
            return new RecipeType<T>(this){

                public String toString() {
                    return resourceLocation.toString();
                }
            };
        });
    }

    default public Holder.Reference<GameEvent> registerGameEvent(String path, int notificationRadius) {
        return this.register(Registries.GAME_EVENT, path, () -> new GameEvent(notificationRadius));
    }

    default public Holder.Reference<SimpleParticleType> registerParticleType(String path) {
        return this.register(Registries.PARTICLE_TYPE, path, () -> new SimpleParticleType(false));
    }

    default public <T extends ParticleOptions> Holder.Reference<ParticleType<T>> registerParticleType(String path, boolean overrideLimiter, final Function<ParticleType<T>, MapCodec<T>> codecGetter, final Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodecGetter) {
        return this.register(Registries.PARTICLE_TYPE, path, () -> new ParticleType<T>(this, overrideLimiter){

            public MapCodec<T> codec() {
                return (MapCodec)codecGetter.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)streamCodecGetter.apply(this);
            }
        });
    }

    default public Holder.Reference<Attribute> registerAttribute(String path, double defaultValue, double minValue, double maxValue) {
        return this.registerAttribute(path, defaultValue, minValue, maxValue, true, Attribute.Sentiment.POSITIVE);
    }

    default public Holder.Reference<Attribute> registerAttribute(String path, double defaultValue, double minValue, double maxValue, boolean syncable, Attribute.Sentiment sentiment) {
        Objects.requireNonNull(sentiment, "sentiment is null");
        return this.register(Registries.ATTRIBUTE, path, () -> new RangedAttribute(this.makeDescriptionId(Registries.ATTRIBUTE, path), defaultValue, minValue, maxValue).setSyncable(syncable).setSentiment(sentiment));
    }

    public <T> Holder.Reference<EntityDataSerializer<T>> registerEntityDataSerializer(String var1, Supplier<EntityDataSerializer<T>> var2);

    default public Holder.Reference<ArmorMaterial> registerArmorMaterial(String path, Holder<Item> repairItem) {
        return this.registerArmorMaterial(path, ItemEquipmentFactories.toArmorTypeMapWithFallback(1, new int[0]), 0, repairItem);
    }

    default public Holder.Reference<ArmorMaterial> registerArmorMaterial(String path, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<Item> repairItem) {
        return this.registerArmorMaterial(path, defense, enchantmentValue, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GENERIC, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)repairItem.value()}), 0.0f, 0.0f);
    }

    default public Holder.Reference<ArmorMaterial> registerArmorMaterial(String path, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        return this.register(Registries.ARMOR_MATERIAL, path, () -> new ArmorMaterial(defense, enchantmentValue, equipSound, repairIngredient, Collections.singletonList(new ArmorMaterial.Layer(this.makeKey(path))), toughness, knockbackResistance));
    }

    default public ResourceKey<DamageType> registerDamageType(String path) {
        return this.makeResourceKey(Registries.DAMAGE_TYPE, path);
    }

    default public ResourceKey<TrimMaterial> registerTrimMaterial(String path) {
        return this.makeResourceKey(Registries.TRIM_MATERIAL, path);
    }

    default public ResourceKey<LootTable> registerLootTable(String path) {
        return this.makeResourceKey(Registries.LOOT_TABLE, path);
    }
}

