/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item.curios;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class PassiveAbilityCurio
extends SimpleDescriptiveCurio {
    public PassiveAbilityCurio(Item.Properties properties, String slotIdentifier) {
        super(properties, slotIdentifier);
    }

    protected abstract int getCooldownTicks();

    public boolean tryProcCooldown(Player player) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        player.getCooldowns().addCooldown((Item)this, this.getCooldownTicks((LivingEntity)player));
        return true;
    }

    public int getCooldownTicks(@Nullable LivingEntity livingEntity) {
        double playerCooldownModifier = livingEntity == null ? 1.0 : livingEntity.getAttributeValue(AttributeRegistry.COOLDOWN_REDUCTION);
        return (int)((double)this.getCooldownTicks() * (2.0 - Utils.softCapFormula(playerCooldownModifier)));
    }

    @Override
    public List<Component> getDescriptionLines(ItemStack stack) {
        return List.of(Component.translatable((String)"tooltip.irons_spellbooks.passive_ability", (Object[])new Object[]{Component.literal((String)Utils.timeFromTicks(this.getCooldownTicks((LivingEntity)MinecraftInstanceHelper.getPlayer()), 1)).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GREEN), this.getDescription(stack));
    }
}

