/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class NeutralWizard
extends AbstractSpellCastingMob
implements NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int lastAngerLevelUpdate;
    private int angerLevel;

    protected NeutralWizard(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        this.addPersistentAngerSaveData(pCompound);
        pCompound.putInt("AngerLevel", this.angerLevel);
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        this.readPersistentAngerSaveData(this.level, pCompound);
        this.angerLevel = pCompound.getInt("AngerLevel");
        super.readAdditionalSaveData(pCompound);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level.isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level, true);
        }
        if (this.angerLevel > 0 && this.lastAngerLevelUpdate + 400 < this.tickCount) {
            --this.angerLevel;
            this.lastAngerLevelUpdate = this.tickCount;
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        Player player;
        Entity entity = pSource.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            this.increaseAngerLevel((int)Math.ceil(pAmount), !this.isHostileTowards((LivingEntity)player));
        }
        return super.hurt(pSource, pAmount);
    }

    public void increaseAngerLevel(int levels, boolean showParticles) {
        if (!this.level.isClientSide && this.angerLevel < this.getAngerThreshold() && showParticles) {
            MagicManager.spawnParticles(this.level, (ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY() + 1.25, this.getZ(), 15, 0.3, 0.2, 0.3, 0.0, false);
            this.getAngerSound().ifPresent(sound -> this.playSound((SoundEvent)sound, this.getSoundVolume(), this.getVoicePitch()));
        }
        this.angerLevel = Math.min(this.angerLevel + levels, 10);
        this.lastAngerLevelUpdate = this.tickCount;
    }

    public Optional<SoundEvent> getAngerSound() {
        return Optional.empty();
    }

    public int getAngerThreshold() {
        return 2;
    }

    public boolean isHostileTowards(LivingEntity entity) {
        return this.isAngryAt(entity) && this.angerLevel >= this.getAngerThreshold();
    }

    public boolean isAngryAt(LivingEntity pTarget) {
        return this.angerLevel > 0 && super.isAngryAt(pTarget);
    }

    public boolean guardsBlocks() {
        return true;
    }
}

