/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public interface IMagicSummon
extends AntiMagicSusceptible {
    public LivingEntity getSummoner();

    public void onUnSummon();

    @Override
    default public void onAntiMagic(MagicData playerMagicData) {
        this.onUnSummon();
    }

    default public boolean shouldIgnoreDamage(DamageSource damageSource) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && damageSource.getEntity() != null && !((Boolean)ServerConfigs.CAN_ATTACK_OWN_SUMMONS.get()).booleanValue()) {
            return this.getSummoner() != null && damageSource.getEntity() != null && (damageSource.getEntity().equals((Object)this.getSummoner()) || this.getSummoner().isAlliedTo(damageSource.getEntity()));
        }
        return false;
    }

    default public boolean isAlliedHelper(Entity entity) {
        OwnableEntity ownableEntity;
        if (this.getSummoner() == null) {
            return false;
        }
        boolean isFellowSummon = entity == this.getSummoner() || entity.isAlliedTo((Entity)this.getSummoner());
        boolean hasCommonOwner = entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).getOwner() == this.getSummoner();
        return isFellowSummon || hasCommonOwner;
    }

    default public void onDeathHelper() {
        IMagicSummon iMagicSummon = this;
        if (iMagicSummon instanceof LivingEntity) {
            LivingEntity livingEntity;
            LivingEntity entity = (LivingEntity)iMagicSummon;
            Level level = entity.level;
            Component deathMessage = entity.getCombatTracker().getDeathMessage();
            if (!level.isClientSide && level.getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.sendSystemMessage(deathMessage);
            }
        }
    }

    default public void onRemovedHelper(Entity entity, DeferredHolder<MobEffect, SummonTimer> holder) {
        LivingEntity livingEntity;
        Entity.RemovalReason reason = entity.getRemovalReason();
        if (reason != null && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (reason.shouldDestroy()) {
                MobEffectInstance effect = player.getEffect(holder);
                if (effect != null) {
                    MobEffectInstance decrement = new MobEffectInstance(holder, effect.getDuration(), effect.getAmplifier() - 1, false, false, true);
                    if (decrement.getAmplifier() >= 0) {
                        player.getActiveEffectsMap().put(holder, decrement);
                        player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(player.getId(), decrement, false));
                    } else {
                        player.removeEffect(holder);
                    }
                }
                if (reason.equals((Object)Entity.RemovalReason.DISCARDED)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"ui.irons_spellbooks.summon_despawn_message", (Object[])new Object[]{((Entity)this).getDisplayName()}));
                }
            }
        }
    }
}

