/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record CreateItemsAction(Optional<QualityScalar> chance, Holder<Item> item, Optional<Holder<SoundEvent>> sound, QualityScalar minCount, QualityScalar maxCount) implements IAction
{
    public static final MapCodec<CreateItemsAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)QualityScalar.CODEC.optionalFieldOf("chance").forGetter(CreateItemsAction::chance), (App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(CreateItemsAction::item), (App)BuiltInRegistries.SOUND_EVENT.holderByNameCodec().optionalFieldOf("sound").forGetter(CreateItemsAction::sound), (App)QualityScalar.CODEC.fieldOf("minCount").forGetter(CreateItemsAction::minCount), (App)QualityScalar.CODEC.fieldOf("maxCount").forGetter(CreateItemsAction::maxCount)).apply((Applicative)builder, CreateItemsAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        Vec3 origin = applyToSelf ? wearer.getBoundingBox().getCenter() : entity.getBoundingBox().getCenter();
        RandomSource random = serverLevel.getRandom();
        if (this.chance.isPresent()) {
            double threshold = this.chance.get().sample(quality);
            if ((double)random.nextFloat() > threshold) {
                return;
            }
        }
        int min = (int)this.minCount.sample(quality);
        int max = (int)this.maxCount.sample(quality);
        int count = Math.max(random.nextIntBetweenInclusive(min, max), 0);
        for (int i = 0; i < count; ++i) {
            ItemStack stack = new ItemStack(this.item);
            float speed = 0.2f + 0.035f * (float)Math.max(count, 8) * (1.0f + random.nextFloat()) * 0.5f;
            Vec3 motion = new Vec3((double)random.nextFloat() - 0.5, (double)(random.nextFloat() * 2.0f + 1.0f), (double)random.nextFloat() - 0.5);
            motion = motion.normalize().scale((double)speed);
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, origin.x, origin.y, origin.z, stack, motion.x, motion.y, motion.z);
            itemEntity.age = 6000;
            itemEntity.lifespan += 6000;
            itemEntity.setPickUpDelay(20);
            serverLevel.addFreshEntity((Entity)itemEntity);
        }
        this.sound.ifPresent(sound -> serverLevel.playSound(null, origin.x, origin.y, origin.z, (SoundEvent)sound.value(), SoundSource.PLAYERS, 1.5f, (float)random.nextIntBetweenInclusive(8, 12) * 0.1f));
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        MutableComponent range;
        int max;
        double quality = bonusInstance.quality();
        int min = (int)this.minCount.sample(quality);
        boolean constant = min == (max = (int)this.maxCount.sample(quality));
        boolean singular = constant && max == 1;
        MutableComponent itemName = Component.translatable((String)((Item)this.item.value()).getDescriptionId()).withStyle(ChatFormatting.GREEN);
        if (singular) {
            if (this.chance.isPresent()) {
                int chance = (int)(this.chance.get().sample(quality) * 100.0);
                return Component.translatable((String)"action.irons_jewelry.create_items.chance.singular", (Object[])new Object[]{chance, itemName});
            }
            return Component.translatable((String)"action.irons_jewelry.create_items.singular", (Object[])new Object[]{itemName});
        }
        MutableComponent mutableComponent = range = constant ? Component.literal((String)String.valueOf(min)) : Component.literal((String)String.format("%s-%s", min, max)).withStyle(ChatFormatting.GOLD);
        if (this.chance.isPresent()) {
            int chance = (int)(this.chance.get().sample(quality) * 100.0);
            return Component.translatable((String)"action.irons_jewelry.create_items.chance", (Object[])new Object[]{chance, range, itemName});
        }
        return Component.translatable((String)"action.irons_jewelry.create_items", (Object[])new Object[]{range, itemName});
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }
}

