/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.parameters.IBonusParameterType;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public class MaterialModifierDataHandler
extends SimpleJsonResourceReloadListener {
    public static final Codec<Modifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IronsJewelryRegistries.Codecs.MATERIAL_REGISTRY_CODEC.fieldOf("targetMaterial").forGetter(Modifier::targetMaterial), (App)IBonusParameterType.BONUS_TO_INSTANCE_CODEC.fieldOf("bonusParameters").forGetter(Modifier::parameterOverrides)).apply((Applicative)builder, Modifier::new));
    private static Multimap<Holder<MaterialDefinition>, Modifier> INSTANCE;

    public MaterialModifierDataHandler() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "irons_jewelry/material_modifier");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        IronsJewelry.LOGGER.debug("MaterialDataHandler.apply");
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ConditionalOps registryops = this.makeConditionalOps();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.getPath().startsWith("_")) continue;
            try {
                Modifier decoded = (Modifier)CODEC.parse((DynamicOps)registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                builder.put(decoded.targetMaterial, (Object)decoded);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                IronsJewelry.LOGGER.error("Parsing error loading material {}: {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        INSTANCE = builder.build();
        IronsJewelry.LOGGER.debug("MaterialDataHandler Finished Loading: {}", INSTANCE);
    }

    public static Map<IBonusParameterType<?>, Object> getParametersWithOverrides(Holder<MaterialDefinition> material) {
        if (INSTANCE == null) {
            return ((MaterialDefinition)material.value()).bonusParameters();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(((MaterialDefinition)material.value()).bonusParameters());
        for (Modifier modifier : INSTANCE.get(material)) {
            Map<IBonusParameterType<?>, Object> overrides = modifier.parameterOverrides;
            for (Map.Entry<IBonusParameterType<?>, Object> e : overrides.entrySet()) {
                builder.put(e.getKey(), e.getValue());
            }
        }
        ImmutableMap map = builder.buildKeepingLast();
        return map;
    }

    public record Modifier(Holder<MaterialDefinition> targetMaterial, Map<IBonusParameterType<?>, Object> parameterOverrides) {
    }
}

