/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class TileEntityHelper {
    public static void dispatchToNearbyPlayers(BlockEntity tile) {
        Level level = tile.getLevel();
        if (level == null) {
            return;
        }
        Packet packet = tile.getUpdatePacket();
        if (packet == null) {
            return;
        }
        List players = level.players();
        BlockPos pos = tile.getBlockPos();
        for (Player player : players) {
            ServerPlayer mPlayer;
            if (!(player instanceof ServerPlayer) || !TileEntityHelper.isPlayerNearby((mPlayer = (ServerPlayer)player).getX(), mPlayer.getZ(), (double)pos.getX() + 0.5, (double)pos.getZ() + 0.5)) continue;
            mPlayer.connection.send(packet);
        }
    }

    public static void dispatchToNearbyPlayers(Level level, int x, int y, int z) {
        BlockEntity tile = level.getBlockEntity(new BlockPos(x, y, z));
        if (tile != null) {
            TileEntityHelper.dispatchToNearbyPlayers(tile);
        }
    }

    private static boolean isPlayerNearby(double x1, double z1, double x2, double z2) {
        return Math.hypot(x1 - x2, z1 - z2) < 64.0;
    }
}

