/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.screen.IJupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.scrollbar.HorizontalScrollBar;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractConfigScreen
extends Screen
implements IJupiterScreen {
    private final Screen parent;
    protected final AbstractConfigContainer configContainer;
    protected final List<TabButton> groupButtons = new ArrayList<TabButton>();
    protected final List<WidgetBuilder<?>> configWidgets = new ArrayList();
    protected final HorizontalScrollBar groupScrollBar = new HorizontalScrollBar();
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    private int currentTab = 0;
    private ConfigGroup currentGroup;
    private int configPerPage;
    private int textMaxLength;

    public AbstractConfigScreen(Screen parent, AbstractConfigContainer configContainer) {
        super((Component)Component.translatable((String)configContainer.getTitleNameKey()));
        this.parent = parent;
        this.configContainer = configContainer;
        this.currentGroup = configContainer.getConfigTabs().get(0);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"<"), button -> this.onClose()).bounds(10, 5, 20, 15).build());
        int x = 10;
        int y = 22;
        this.groupButtons.clear();
        List<ConfigGroup> configTabs = this.configContainer.getConfigTabs();
        for (int i = 0; i < configTabs.size(); ++i) {
            ConfigGroup category = configTabs.get(i);
            TabButton tabButton = (TabButton)this.addRenderableWidget((GuiEventListener)new TabButton(category, x, y, this.font.width(I18n.get((String)category.getTranslateKey(), (Object[])new Object[0])) + 10, 20, button -> {
                this.currentTab = this.configContainer.getConfigTabs().indexOf(button.group);
                this.currentGroup = button.group;
                this.rebuildWidgets();
            }));
            tabButton.active = i != this.currentTab;
            this.groupButtons.add(tabButton);
            x += tabButton.getWidth() + 2;
        }
        this.groupScrollBar.setMaxValue(Math.max(0, (x += 10) - this.width));
        this.calculateMaxItems();
        this.textMaxLength = this.currentGroup.getConfigs().stream().map(IConfigEntry::getNameKey).map(x$0 -> I18n.get((String)x$0, (Object[])new Object[0])).map(t -> this.font.width(t)).max(Comparator.naturalOrder()).orElse(0) + 30;
        this.configWidgets.clear();
        this.configWidgets.addAll(this.currentGroup.getConfigs().stream().map(WidgetBuilderManager::get).toList());
        this.configWidgets.forEach(b -> b.addElements(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, this.textMaxLength, 0, Math.max(10, this.width - this.textMaxLength - 30), 20));
        this.updateItemPos();
    }

    protected void updateTabPos() {
        for (TabButton button : this.groupButtons) {
            button.updatePos(this.groupScrollBar.getValue());
        }
    }

    public void resize(Minecraft client, int width, int height) {
        super.resize(client, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.height - 55) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, this.currentGroup.getConfigs().size() - this.configPerPage));
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        List<IConfigEntry<?>> entries = this.currentGroup.getConfigs();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.configWidgets.get(i).update(true, 60 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (mouseX >= 10.0 && mouseX <= (double)(this.width - 20) && mouseY >= 22.0 && mouseY <= 42.0) {
            this.groupScrollBar.setValue(this.groupScrollBar.getValue() + (horizontalAmount > 0.0 ? -20 : 20));
            this.updateTabPos();
            return true;
        }
        if (mouseY > 42.0) {
            this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (verticalAmount > 0.0 ? -1 : 1) * 2);
            this.updateItemPos();
            return true;
        }
        return false;
    }

    public void onClose() {
        this.configContainer.onConfigsChanged();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(context, mouseX, mouseY, partialTicks);
        super.render(context, mouseX, mouseY, partialTicks);
        context.drawString(this.font, this.title, 35, 10, -1, true);
        String currentText = this.getCurrentEditText();
        int textWidth = this.font.width(currentText);
        context.drawString(this.font, currentText, this.width - textWidth - 10, 10, -1);
        this.groupScrollBar.render(mouseX, mouseY, partialTicks, 10, 43, this.width - 20, 8, this.width + this.groupScrollBar.getMaxValue());
        if (this.groupScrollBar.isDragging()) {
            this.updateTabPos();
        }
        this.itemScrollBar.render(mouseX, mouseY, partialTicks, this.width - 18, 55, 8, this.height - 70, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.groupScrollBar.wasMouseOver()) {
            this.groupScrollBar.setIsDragging(true);
            this.updateTabPos();
            return true;
        }
        if (mouseButton == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (!b) {
            this.setFocused(null);
        }
        return b;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.groupScrollBar.setIsDragging(false);
            this.itemScrollBar.setIsDragging(false);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    protected abstract String getCurrentEditText();

    public static class TabButton
    extends Button {
        private final ConfigGroup group;
        private final int baseX;

        public TabButton(ConfigGroup group, int baseX, int y, int width, int height, Consumer<TabButton> listener) {
            super(baseX, y, width, height, (Component)Component.translatable((String)group.getTranslateKey()), button -> listener.accept((TabButton)button), DEFAULT_NARRATION);
            this.group = group;
            this.baseX = baseX;
        }

        public void updatePos(int offsetX) {
            this.setX(this.baseX - offsetX);
        }
    }
}

