/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.interfaces.IConfigHandler;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class JupiterConfigListWidget
extends ObjectSelectionList<ConfigEntry> {
    private final JupiterConfigListScreen screen;
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public JupiterConfigListWidget(JupiterConfigListScreen screen, Minecraft client, int width, int height, int y, int entryHeight) {
        super(client, width, height, y, entryHeight);
        this.screen = screen;
    }

    public void update() {
        this.entries.clear();
        ConfigManager.getInstance().getAllHandlers().forEach(x -> this.entries.add(new ConfigEntry(this.screen, (IConfigHandler)x)));
        this.updateEntries();
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 30;
    }

    private void updateEntries() {
        this.clearEntries();
        this.entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        ConfigEntry entry = (ConfigEntry)this.getSelected();
        return entry != null && entry.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public static class ConfigEntry
    extends ObjectSelectionList.Entry<ConfigEntry> {
        private final Minecraft client = Minecraft.getInstance();
        private final JupiterConfigListScreen screen;
        private final IConfigHandler handler;

        public ConfigEntry(JupiterConfigListScreen screen, IConfigHandler handler) {
            this.screen = screen;
            this.handler = handler;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.drawString(this.client.font, (Component)Component.translatable((String)this.handler.getTitleNameKey()), x + 32 + 3, y + 1, 0xFFFFFF, true);
            context.drawString(this.client.font, this.handler.getConfigId().toString(), x + 32 + 3, y + 1 + 9, 0xFFFFFF, true);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.screen.select(this);
            return false;
        }

        public IConfigHandler getConfigContainer() {
            return this.handler;
        }

        public Component getNarration() {
            return Component.nullToEmpty((String)"");
        }
    }
}

