/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.neoforge.services;

import com.anthonyhilyard.iceberg.services.IPlatformHelper;
import java.util.List;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private List<String> cachedModList = null;

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        if (modId == null || modId.isEmpty()) {
            return false;
        }
        if (ModList.get() != null) {
            return ModList.get().isLoaded(modId);
        }
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public List<String> getAllModIds() {
        if (this.cachedModList == null) {
            this.cachedModList = ModList.get() != null ? ModList.get().applyForEachModContainer(mod -> mod.getModId()).toList() : LoadingModList.get().getMods().stream().map(ModInfo::getModId).toList();
        }
        return this.cachedModList;
    }

    @Override
    public boolean modVersionMeets(String modId, String versionString) {
        if (versionString.contains("<") || versionString.contains(">") || versionString.contains("=") || versionString.contains("~")) {
            return false;
        }
        boolean result = false;
        if (this.isModLoaded(modId)) {
            try {
                result = ((ModContainer)ModList.get().getModContainerById(modId).get()).getModInfo().getVersion().compareTo((Object)new DefaultArtifactVersion(versionString)) >= 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

