/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.include.com.google.common.base.Preconditions;

public record LootPatternMatcher(Optional<String> domain, Pattern pathRegex) {
    public static final Codec<LootPatternMatcher> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("domain").forGetter(LootPatternMatcher::domain), (App)Codec.STRING.xmap(Pattern::compile, Pattern::toString).fieldOf("path_regex").forGetter(LootPatternMatcher::pathRegex)).apply((Applicative)inst, LootPatternMatcher::new));

    public static LootPatternMatcher of(String domain, String regex) {
        Preconditions.checkArgument((!domain.isBlank() ? 1 : 0) != 0);
        return new LootPatternMatcher(Optional.of(domain), Pattern.compile(regex));
    }

    public static LootPatternMatcher of(String regex) {
        return new LootPatternMatcher(Optional.empty(), Pattern.compile(regex));
    }

    public boolean matches(ResourceLocation id) {
        return (this.domain.isEmpty() || this.domain.get().equals(id.getNamespace())) && this.pathRegex.matcher(id.getPath()).matches();
    }
}

