/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public class ApothMiscUtil {
    public static int getExpCostForSlot(int level, int slot) {
        int cost = 0;
        for (int i = 0; i <= slot; ++i) {
            cost += EnchantmentUtils.getExperienceForLevel((int)(level - i));
        }
        return cost - 1;
    }

    public static int[] doubleUpGradient(int[] data) {
        int[] out = new int[data.length * 2];
        System.arraycopy(data, 0, out, 0, data.length);
        for (int i = data.length - 1; i >= 0; --i) {
            out[data.length * 2 - 1 - i] = data[i];
        }
        return out;
    }

    @Nullable
    public static Player getClientPlayer() {
        return FMLEnvironment.dist.isClient() ? ClientInternal.getClientPlayer() : null;
    }

    public static double duraProd(double result, double element) {
        return result + (1.0 - result) * element;
    }

    @SafeVarargs
    public static <T> Set<T> linkedSet(T ... objects) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T t : objects) {
            set.add(t);
        }
        return set;
    }

    public static boolean hasAdvancement(Player player, ResourceLocation key) {
        if (player.level().isClientSide) {
            return ClientInternal.hasAdvancment(key);
        }
        PlayerAdvancements advancements = ((ServerPlayer)player).getAdvancements();
        ServerAdvancementManager manager = player.getServer().getAdvancements();
        AdvancementHolder holder = manager.get(key);
        if (holder != null) {
            AdvancementProgress progress = (AdvancementProgress)advancements.progress.get(holder);
            return progress != null && progress.isDone();
        }
        return false;
    }

    public static <T> Holder.Reference<T> standaloneHolder(HolderLookup.Provider registries, ResourceKey<T> key) {
        HolderOwner owner = (HolderOwner)registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE).owner(key.registryKey()).get();
        return Holder.Reference.createStandAlone((HolderOwner)owner, key);
    }

    public static MutableComponent dotPrefix(Component comp) {
        return Apotheosis.lang("text", "dot_prefix", comp);
    }

    public static MutableComponent starPrefix(Component comp) {
        return Apotheosis.lang("text", "star_prefix", comp);
    }

    private static class ClientInternal {
        private ClientInternal() {
        }

        public static Player getClientPlayer() {
            return Minecraft.getInstance().player;
        }

        public static boolean hasAdvancment(ResourceLocation key) {
            ClientAdvancements advancements = Minecraft.getInstance().getConnection().getAdvancements();
            AdvancementHolder holder = advancements.get(key);
            if (holder != null) {
                AdvancementProgress progress = (AdvancementProgress)advancements.progress.get(holder);
                return progress != null && progress.isDone();
            }
            return false;
        }
    }
}

