/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class AffixItemIngredient
implements ICustomIngredient {
    public static final MapCodec<AffixItemIngredient> CODEC = RarityRegistry.INSTANCE.holderCodec().fieldOf("rarity").xmap(AffixItemIngredient::new, a -> a.rarity);
    public static final StreamCodec<ByteBuf, AffixItemIngredient> STREAM_CODEC = RarityRegistry.INSTANCE.holderStreamCodec().map(AffixItemIngredient::new, a -> a.rarity);
    public static final IngredientType<AffixItemIngredient> TYPE = new IngredientType(CODEC, STREAM_CODEC);
    protected final DynamicHolder<LootRarity> rarity;

    public AffixItemIngredient(DynamicHolder<LootRarity> rarity) {
        this.rarity = rarity;
    }

    public boolean test(ItemStack stack) {
        DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(stack);
        Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        return affixes.size() > 0 && rarity.isBound() && rarity == this.rarity;
    }

    public Stream<ItemStack> getItems() {
        return AffixItemIngredient.createFakeDisplayItems(this.getRarity());
    }

    public boolean isSimple() {
        return false;
    }

    public LootRarity getRarity() {
        return (LootRarity)this.rarity.get();
    }

    public IngredientType<?> getType() {
        return TYPE;
    }

    private static Stream<ItemStack> createFakeDisplayItems(LootRarity rarity) {
        LegacyRandomSource src = new LegacyRandomSource(0L);
        return Arrays.asList(Items.DIAMOND_SWORD, Items.DIAMOND_PICKAXE, Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS).stream().map(ItemStack::new).map(arg_0 -> AffixItemIngredient.lambda$createFakeDisplayItems$2(rarity, (RandomSource)src, arg_0));
    }

    private static /* synthetic */ ItemStack lambda$createFakeDisplayItems$2(LootRarity rarity, RandomSource src, ItemStack stack) {
        LootController.createLootItem(stack, rarity, GenContext.dummy(src));
        AffixHelper.setName(stack, (Component)Component.translatable((String)"text.apotheosis.any_x_item", (Object[])new Object[]{rarity.toComponent(), ""}).withStyle(Style.EMPTY.withColor(rarity.color()).withItalic(Boolean.valueOf(false))));
        return stack;
    }
}

