/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingMenu;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public class GemCuttingScreen
extends AdventureContainerScreen<GemCuttingMenu> {
    public static final ResourceLocation TEXTURE = Apotheosis.loc("textures/gui/gem_cutting.png");
    protected SimpleTexButton upgradeBtn;

    public GemCuttingScreen(GemCuttingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        ((GemCuttingMenu)this.menu).slotChangedCallback = this::updateBtnStatus;
        this.imageHeight = 180;
        this.titleLabelY = 5;
        this.inventoryLabelY = 86;
    }

    protected void init() {
        super.init();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.upgradeBtn = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)new SimpleTexButton(left + 135, top + 44, 18, 18, 238, 0, TEXTURE, 256, 256, this::clickUpgradeBtn, (Component)Component.translatable((String)"button.apotheosis.upgrade")).setInactiveMessage((Component)Component.translatable((String)"button.apotheosis.upgrade.no").withStyle(ChatFormatting.RED)));
        this.updateBtnStatus();
    }

    protected void clickUpgradeBtn(Button btn) {
        this.minecraft.gameMode.handleInventoryButtonClick(((GemCuttingMenu)this.menu).containerId, 0);
        GemUpgradeSound.start(((GemCuttingMenu)this.menu).player.blockPosition());
    }

    protected void updateBtnStatus() {
        for (RecipeHolder<GemCuttingRecipe> holder : GemCuttingMenu.getRecipes((Level)Minecraft.getInstance().level)) {
            GemCuttingRecipe r = (GemCuttingRecipe)holder.value();
            if (!r.matches((RecipeInput)((GemCuttingMenu)this.menu).rInput, (Level)Minecraft.getInstance().level)) continue;
            this.upgradeBtn.active = true;
            return;
        }
        if (this.upgradeBtn != null) {
            this.upgradeBtn.active = false;
        }
    }

    protected void renderBg(GuiGraphics gfx, float pPartialTick, int pMouseX, int pMouseY) {
        int xCenter = (this.width - this.imageWidth) / 2;
        int yCenter = (this.height - this.imageHeight) / 2;
        gfx.blit(TEXTURE, xCenter, yCenter, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected static class GemUpgradeSound
    extends AbstractTickableSoundInstance {
        protected int ticks = 0;
        protected float pitchOff;

        public GemUpgradeSound(BlockPos pos) {
            super(SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, Minecraft.getInstance().level.random);
            this.x = (float)pos.getX() + 0.5f;
            this.y = pos.getY();
            this.z = (float)pos.getZ() + 0.5f;
            this.volume = 1.5f;
            this.pitch = 1.5f + 0.35f * (1.0f - 2.0f * this.random.nextFloat());
            this.pitchOff = 0.35f * (1.0f - 2.0f * this.random.nextFloat());
            this.delay = 999;
        }

        public void tick() {
            if (this.ticks == 4 || this.ticks == 9) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.AMETHYST_BLOCK_BREAK, (float)(this.pitch + this.pitchOff), (float)1.5f));
                this.pitchOff = -this.pitchOff;
            }
            if (this.ticks++ > 8) {
                this.stop();
            }
        }

        public static void start(BlockPos pos) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new GemUpgradeSound(pos));
        }
    }
}

