/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.socket.gem.PurityWeightsRegistry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.color.GradientColor;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;

public enum Purity implements StringRepresentable,
TieredWeights.Weighted
{
    CRACKED("cracked", 0x808080),
    CHIPPED("chipped", 0x33FF33),
    FLAWED("flawed", 0x5555FF),
    NORMAL("normal", 0xBB00BB),
    FLAWLESS("flawless", 15560724),
    PERFECT("perfect", (TextColor)GradientColor.RAINBOW);

    public static final IntFunction<Purity> BY_ID;
    public static final Codec<Purity> CODEC;
    public static final StreamCodec<ByteBuf, Purity> STREAM_CODEC;
    public static final Set<Purity> ALL_PURITIES;
    private final String name;
    private final TextColor color;

    private Purity(String name, TextColor color) {
        this.name = name;
        this.color = color;
    }

    private Purity(String name, int color) {
        this(name, TextColor.fromRgb((int)color));
    }

    public String getName() {
        return this.name;
    }

    public TextColor getColor() {
        return this.color;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Override
    public TieredWeights weights() {
        return PurityWeightsRegistry.getWeights().get(this);
    }

    public Purity next() {
        return this == PERFECT ? this : BY_ID.apply(this.ordinal() + 1);
    }

    public boolean isAtLeast(Purity other) {
        return this.ordinal() >= other.ordinal();
    }

    public MutableComponent toComponent() {
        return Apotheosis.lang("purity", this.getSerializedName(), new Object[0]).withStyle(Style.EMPTY.withColor(this.color));
    }

    public static Purity max(Purity p1, Purity p2) {
        return BY_ID.apply(Math.max(p1.ordinal(), p2.ordinal()));
    }

    public static Purity random(GenContext ctx) {
        return Purity.random(ctx, ALL_PURITIES);
    }

    public static Purity random(GenContext ctx, Set<Purity> pool) {
        if (pool.isEmpty()) {
            pool = ALL_PURITIES;
        }
        List<WeightedEntry.Wrapper> list = pool.stream().map(l -> l.wrap(ctx.tier(), ctx.luck())).toList();
        return WeightedRandom.getRandomItem((RandomSource)ctx.rand(), list).map(WeightedEntry.Wrapper::data).orElse(CRACKED);
    }

    public static <T> MapCodec<Map<Purity, T>> mapCodec(Codec<T> elementCodec) {
        return Codec.simpleMap(CODEC, elementCodec, (Keyable)Keyable.forStrings(() -> Arrays.stream(Purity.values()).map(StringRepresentable::getSerializedName)));
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Purity.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromValues(Purity::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        ALL_PURITIES = ApothMiscUtil.linkedSet(CRACKED, CHIPPED, FLAWED, NORMAL, FLAWLESS, PERFECT);
    }
}

