/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.item.PotionCharmItem;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class PotionCharmRecipe
extends ShapedRecipe {
    public PotionCharmRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern) {
        super(group, category, pattern, new ItemStack(Apoth.Items.POTION_CHARM));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider regs) {
        ItemStack out = super.assemble(inv, regs);
        PotionContents contents = PotionCharmRecipe.findPotion(inv);
        if (contents == PotionContents.EMPTY) {
            return ItemStack.EMPTY;
        }
        Holder potion = (Holder)contents.potion().get();
        out.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        return out;
    }

    public boolean matches(CraftingInput inv, Level world) {
        if (super.matches(inv, world)) {
            return PotionCharmRecipe.findPotion(inv) != PotionContents.EMPTY;
        }
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static PotionContents findPotion(CraftingInput input) {
        PotionContents found = PotionContents.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (contents == null) continue;
            if (!PotionCharmItem.isValidPotion((Holder<Potion>)contents.potion().orElse(Potions.WATER))) {
                return PotionContents.EMPTY;
            }
            if (found == PotionContents.EMPTY) {
                found = contents;
                continue;
            }
            if (contents.equals((Object)found)) continue;
            return PotionContents.EMPTY;
        }
        return found;
    }

    public static class Serializer
    implements RecipeSerializer<PotionCharmRecipe> {
        public static final MapCodec<PotionCharmRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern)).apply((Applicative)inst, PotionCharmRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionCharmRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<PotionCharmRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionCharmRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static PotionCharmRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            return new PotionCharmRecipe(s, craftingbookcategory, shapedrecipepattern);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, PotionCharmRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
        }
    }
}

