/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, remap=false)
public class LivingEntityMixin {
    @Unique
    @Nullable
    private Float originalHealthPercent;

    @Inject(method={"detectEquipmentUpdates"}, at={@At(value="HEAD")})
    private void apoth_cacheLastHealthPct(CallbackInfo ci) {
        if (!this.isPlayer()) {
            LivingEntity self = (LivingEntity)this;
            this.originalHealthPercent = self.getHealth() > 0.0f && self.getMaxHealth() > 0.0f ? Float.valueOf(self.getHealth() / self.getMaxHealth()) : null;
        }
    }

    @Inject(method={"detectEquipmentUpdates"}, at={@At(value="TAIL")})
    private void apoth_updateHealthPct(CallbackInfo ci) {
        if (this.originalHealthPercent != null) {
            LivingEntity self = (LivingEntity)this;
            self.setHealth(self.getMaxHealth() * this.originalHealthPercent.floatValue());
            this.originalHealthPercent = null;
        }
    }

    private boolean isPlayer() {
        return this instanceof Player;
    }
}

