/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.loot.modifiers.ContextualLootModifier;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.util.LootPatternMatcher;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public class AffixConvertLootModifier
extends ContextualLootModifier {
    public static final MapCodec<AffixConvertLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AffixConvertLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)AffixConversionEntry.CODEC.listOf().fieldOf("entries").forGetter(g -> g.entries)).apply((Applicative)inst, AffixConvertLootModifier::new));
    protected final List<AffixConversionEntry> entries;

    public AffixConvertLootModifier(LootItemCondition[] conditions, List<AffixConversionEntry> entries) {
        super(conditions);
        this.entries = entries;
    }

    @Override
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context, GenContext gCtx) {
        for (AffixConversionEntry entry : this.entries) {
            if (!entry.pattern.matches(context.getQueriedLootTableId())) continue;
            RandomSource rand = context.getRandom();
            if (entry.chance() <= 0.0f) break;
            for (ItemStack s : generatedLoot) {
                if (LootCategory.forItem(s).isNone() || !AffixHelper.getAffixes(s).isEmpty() || !(rand.nextFloat() <= entry.chance())) continue;
                LootRarity rarity = LootRarity.randomFromHolders(gCtx, entry.rarities);
                LootController.createLootItem(s, rarity, gCtx);
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public record AffixConversionEntry(LootPatternMatcher pattern, float chance, Set<DynamicHolder<LootRarity>> rarities) {
        public static final Codec<AffixConversionEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootPatternMatcher.CODEC.fieldOf("pattern").forGetter(AffixConversionEntry::pattern), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(AffixConversionEntry::chance), (App)PlaceboCodecs.setOf((Codec)RarityRegistry.INSTANCE.holderCodec()).optionalFieldOf("rarities", Set.of()).forGetter(AffixConversionEntry::rarities)).apply((Applicative)inst, AffixConversionEntry::new));
    }
}

