/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record MatchesBlockCondition(HolderSet<Block> blocks) implements LootItemCondition
{
    public static final MapCodec<MatchesBlockCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("valid_blocks").forGetter(MatchesBlockCondition::blocks)).apply((Applicative)inst, MatchesBlockCondition::new));

    public boolean test(LootContext ctx) {
        if (ctx.hasParam(LootContextParams.BLOCK_STATE)) {
            BlockState state = (BlockState)ctx.getParam(LootContextParams.BLOCK_STATE);
            return this.blocks.contains(state.getBlockHolder());
        }
        return false;
    }

    public LootItemConditionType getType() {
        return Apoth.LootConditions.MATCHES_BLOCK;
    }
}

