/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.UnnamingRecipe;
import dev.shadowsoffire.apotheosis.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.recipe.CharmInfusionRecipe;
import dev.shadowsoffire.apotheosis.recipe.MaliceRecipe;
import dev.shadowsoffire.apotheosis.recipe.PotionCharmRecipe;
import dev.shadowsoffire.apotheosis.socket.AddSocketsRecipe;
import dev.shadowsoffire.apotheosis.socket.SocketingRecipe;
import dev.shadowsoffire.apotheosis.socket.WithdrawalRecipe;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.PurityUpgradeRecipe;
import dev.shadowsoffire.apotheosis.util.AffixItemIngredient;
import dev.shadowsoffire.apotheosis.util.GemIngredient;
import dev.shadowsoffire.apotheosis.util.SizedUpgradeRecipe;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import dev.shadowsoffire.placebo.datagen.LegacyRecipeProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class ApothRecipeProvider
extends LegacyRecipeProvider {
    public ApothRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "apotheosis");
    }

    protected void genRecipes(RecipeOutput out, HolderLookup.Provider registries) {
        out.accept(Apotheosis.loc("socketing"), (Recipe)new SocketingRecipe(), null);
        out.accept(Apotheosis.loc("unnaming"), (Recipe)new UnnamingRecipe(), null);
        out.accept(Apotheosis.loc("widthdrawal"), (Recipe)new WithdrawalRecipe(), null);
        out.accept(Apotheosis.loc("malice"), (Recipe)new MaliceRecipe(), null);
        this.addSockets("sigil_add_sockets", ApothRecipeProvider.ingredient(Apoth.Items.SIGIL_OF_SOCKETING), 2);
        this.addAffixSalvaging("common", Apoth.Items.COMMON_MATERIAL);
        this.addAffixSalvaging("uncommon", Apoth.Items.UNCOMMON_MATERIAL);
        this.addAffixSalvaging("rare", Apoth.Items.RARE_MATERIAL);
        this.addAffixSalvaging("epic", Apoth.Items.EPIC_MATERIAL);
        this.addAffixSalvaging("mythic", Apoth.Items.MYTHIC_MATERIAL);
        this.addGemSalvaging(Purity.CRACKED, 1, 2);
        this.addGemSalvaging(Purity.CHIPPED, 1, 3);
        this.addGemSalvaging(Purity.FLAWED, 2, 4);
        this.addGemSalvaging(Purity.NORMAL, 3, 5);
        this.addGemSalvaging(Purity.FLAWLESS, 4, 7);
        this.addGemSalvaging(Purity.PERFECT, 5, 10);
        this.addOtherSalvaging("leather_horse_armor", new SalvagingRecipe.OutputData(Apoth.Items.LEATHER, 3, 8), Apoth.Items.LEATHER_HORSE_ARMOR);
        this.addOtherSalvaging("iron_horse_armor", new SalvagingRecipe.OutputData(Apoth.Items.IRON_INGOT, 3, 8), Apoth.Items.IRON_HORSE_ARMOR);
        this.addOtherSalvaging("golden_horse_armor", new SalvagingRecipe.OutputData(Apoth.Items.GOLD_INGOT, 3, 8), Apoth.Items.GOLDEN_HORSE_ARMOR);
        this.addOtherSalvaging("diamond_horse_armor", new SalvagingRecipe.OutputData(Apoth.Items.DIAMOND, 3, 8), Apoth.Items.DIAMOND_HORSE_ARMOR);
        this.addOtherSalvaging("wolf_armor", new SalvagingRecipe.OutputData(Apoth.Items.ARMADILLO_SCUTE, 1, 3), Apoth.Items.WOLF_ARMOR);
        this.addOtherSalvaging("wooden_tools", new SalvagingRecipe.OutputData(Apoth.Items.OAK_PLANKS, 0, 1), Apoth.Items.WOODEN_SWORD, Apoth.Items.WOODEN_PICKAXE, Apoth.Items.WOODEN_AXE, Apoth.Items.WOODEN_SHOVEL, Apoth.Items.WOODEN_HOE);
        this.addOtherSalvaging("stone_tools", new SalvagingRecipe.OutputData(Apoth.Items.COBBLESTONE, 0, 1), Apoth.Items.STONE_SWORD, Apoth.Items.STONE_PICKAXE, Apoth.Items.STONE_AXE, Apoth.Items.STONE_SHOVEL, Apoth.Items.STONE_HOE);
        this.addOtherSalvaging("gold_tools", new SalvagingRecipe.OutputData(Apoth.Items.GOLD_INGOT, 0, 1), Apoth.Items.GOLDEN_SWORD, Apoth.Items.GOLDEN_PICKAXE, Apoth.Items.GOLDEN_AXE, Apoth.Items.GOLDEN_SHOVEL, Apoth.Items.GOLDEN_HOE);
        this.addOtherSalvaging("iron_tools", new SalvagingRecipe.OutputData(Apoth.Items.IRON_INGOT, 0, 1), Apoth.Items.IRON_SWORD, Apoth.Items.IRON_PICKAXE, Apoth.Items.IRON_AXE, Apoth.Items.IRON_SHOVEL, Apoth.Items.IRON_HOE);
        this.addOtherSalvaging("diamond_tools", new SalvagingRecipe.OutputData(Apoth.Items.DIAMOND, 0, 1), Apoth.Items.DIAMOND_SWORD, Apoth.Items.DIAMOND_PICKAXE, Apoth.Items.DIAMOND_AXE, Apoth.Items.DIAMOND_SHOVEL, Apoth.Items.DIAMOND_HOE);
        this.addOtherSalvaging("netherite_tools", new SalvagingRecipe.OutputData(Apoth.Items.NETHERITE_SCRAP, 0, 2), Apoth.Items.NETHERITE_SWORD, Apoth.Items.NETHERITE_PICKAXE, Apoth.Items.NETHERITE_AXE, Apoth.Items.NETHERITE_SHOVEL, Apoth.Items.NETHERITE_HOE);
        this.addOtherSalvaging("leather_armor", new SalvagingRecipe.OutputData(Apoth.Items.LEATHER, 1, 3), Apoth.Items.LEATHER_HELMET, Apoth.Items.LEATHER_CHESTPLATE, Apoth.Items.LEATHER_LEGGINGS, Apoth.Items.LEATHER_BOOTS);
        this.addOtherSalvaging("chain_armor", new SalvagingRecipe.OutputData(Apoth.Items.CHAIN, 1, 3), Apoth.Items.CHAINMAIL_HELMET, Apoth.Items.CHAINMAIL_CHESTPLATE, Apoth.Items.CHAINMAIL_LEGGINGS, Apoth.Items.CHAINMAIL_BOOTS);
        this.addOtherSalvaging("gold_armor", new SalvagingRecipe.OutputData(Apoth.Items.GOLD_INGOT, 1, 3), Apoth.Items.GOLDEN_HELMET, Apoth.Items.GOLDEN_CHESTPLATE, Apoth.Items.GOLDEN_LEGGINGS, Apoth.Items.GOLDEN_BOOTS);
        this.addOtherSalvaging("iron_armor", new SalvagingRecipe.OutputData(Apoth.Items.IRON_INGOT, 1, 3), Apoth.Items.IRON_HELMET, Apoth.Items.IRON_CHESTPLATE, Apoth.Items.IRON_LEGGINGS, Apoth.Items.IRON_BOOTS);
        this.addOtherSalvaging("diamond_armor", new SalvagingRecipe.OutputData(Apoth.Items.DIAMOND, 1, 3), Apoth.Items.DIAMOND_HELMET, Apoth.Items.DIAMOND_CHESTPLATE, Apoth.Items.DIAMOND_LEGGINGS, Apoth.Items.DIAMOND_BOOTS);
        this.addOtherSalvaging("netherite_armor", new SalvagingRecipe.OutputData(Apoth.Items.NETHERITE_SCRAP, 0, 2), Apoth.Items.NETHERITE_HELMET, Apoth.Items.NETHERITE_CHESTPLATE, Apoth.Items.NETHERITE_LEGGINGS, Apoth.Items.NETHERITE_BOOTS);
        this.addReforging("common", 1, 0, 2, Apoth.Blocks.SIMPLE_REFORGING_TABLE, Apoth.Blocks.REFORGING_TABLE);
        this.addReforging("uncommon", 2, 1, 5, Apoth.Blocks.SIMPLE_REFORGING_TABLE, Apoth.Blocks.REFORGING_TABLE);
        this.addReforging("rare", 2, 2, 15, Apoth.Blocks.SIMPLE_REFORGING_TABLE, Apoth.Blocks.REFORGING_TABLE);
        this.addReforging("epic", 2, 4, 30, Apoth.Blocks.REFORGING_TABLE);
        this.addReforging("mythic", 3, 5, 50, Apoth.Blocks.REFORGING_TABLE);
        this.addShaped(Apoth.Blocks.AUGMENTING_TABLE, 3, 3, new Object[]{null, Apoth.Items.NETHER_STAR, null, Apoth.Items.MYTHIC_MATERIAL, Apoth.Items.ENCHANTING_TABLE, Apoth.Items.MYTHIC_MATERIAL, Apoth.Items.POLISHED_BLACKSTONE, Apoth.Items.POLISHED_BLACKSTONE, Apoth.Items.POLISHED_BLACKSTONE});
        this.addShaped(Apoth.Blocks.GEM_CUTTING_TABLE, 3, 3, new Object[]{Apoth.Items.SMOOTH_STONE, Apoth.Items.SHEARS, Apoth.Items.SMOOTH_STONE, ItemTags.PLANKS, Apoth.Items.GEM_DUST, ItemTags.PLANKS, ItemTags.PLANKS, null, ItemTags.PLANKS});
        this.addShaped(new ItemStack(Apoth.Items.GEM_FUSED_SLATE, 8), 3, 3, new Object[]{Apoth.Items.DEEPSLATE, Apoth.Items.DEEPSLATE, Apoth.Items.DEEPSLATE, Apoth.Items.DEEPSLATE, Apoth.Items.GEM_DUST, Apoth.Items.DEEPSLATE, Apoth.Items.DEEPSLATE, Apoth.Items.DEEPSLATE, Apoth.Items.DEEPSLATE});
        this.addShaped(Apoth.Blocks.REFORGING_TABLE, 3, 3, new Object[]{null, Tags.Items.INGOTS_NETHERITE, null, Apoth.Items.EPIC_MATERIAL, Apoth.Items.SIMPLE_REFORGING_TABLE, Apoth.Items.EPIC_MATERIAL, Apoth.Items.NETHER_BRICKS, Apoth.Items.NETHER_BRICKS, Apoth.Items.NETHER_BRICKS});
        this.addShaped(Apoth.Blocks.SALVAGING_TABLE, 3, 3, new Object[]{Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_COPPER, Apoth.Items.IRON_PICKAXE, Apoth.Items.SMITHING_TABLE, Apoth.Items.IRON_AXE, Apoth.Items.GEM_DUST, Apoth.Items.LAVA_BUCKET, Apoth.Items.GEM_DUST});
        this.addShaped(Apoth.Blocks.SIMPLE_REFORGING_TABLE, 3, 3, new Object[]{null, Tags.Items.INGOTS_IRON, null, Apoth.Items.GEM_DUST, Apoth.Items.ENCHANTING_TABLE, Apoth.Items.GEM_DUST, Apoth.Items.SMOOTH_STONE, Apoth.Items.SMOOTH_STONE, Apoth.Items.SMOOTH_STONE});
        this.addShaped(new ItemStack(Apoth.Items.SIGIL_OF_ENHANCEMENT, 4), 3, 3, new Object[]{Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.MYTHIC_MATERIAL, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_DUST});
        this.addShaped(new ItemStack(Apoth.Items.SIGIL_OF_REBIRTH, 6), 3, 3, new Object[]{Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_DUST, Apoth.Items.GEM_DUST, Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE});
        this.addShaped(new ItemStack(Apoth.Items.SIGIL_OF_SOCKETING, 3), 3, 3, new Object[]{Apoth.Items.GEM_DUST, Apoth.Items.GUNPOWDER, Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_DUST, Apoth.Items.AMETHYST_SHARD, Apoth.Items.GEM_DUST});
        this.addShaped(new ItemStack(Apoth.Items.SIGIL_OF_UNNAMING, 6), 3, 3, new Object[]{Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.FLINT, Apoth.Items.FLINT, Apoth.Items.FLINT, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_FUSED_SLATE});
        this.addShaped(new ItemStack(Apoth.Items.SIGIL_OF_WITHDRAWAL, 4), 3, 3, new Object[]{Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.BLAZE_ROD, Apoth.Items.GEM_FUSED_SLATE, Tags.Items.ENDER_PEARLS, Apoth.Items.LAVA_BUCKET, Tags.Items.ENDER_PEARLS, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE});
        List<Holder<Item>> rarityMaterials = List.of(Apoth.Items.COMMON_MATERIAL, Apoth.Items.UNCOMMON_MATERIAL, Apoth.Items.RARE_MATERIAL, Apoth.Items.EPIC_MATERIAL, Apoth.Items.MYTHIC_MATERIAL);
        for (int i = 0; i < Purity.values().length - 1; ++i) {
            Purity purity = Purity.BY_ID.apply(i);
            List<Holder<Item>> materials = rarityMaterials.subList(Math.max(i - 2, 0), Math.min(i + 2, rarityMaterials.size()));
            int zeroCost = switch (purity) {
                case Purity.CRACKED -> 3;
                case Purity.CHIPPED -> 9;
                default -> 27;
            };
            this.addPurityUpgrade(purity, 1 + i * 2, materials, zeroCost);
        }
        out.accept(Apotheosis.loc("potion_charm"), (Recipe)new PotionCharmRecipe("", CraftingBookCategory.MISC, this.charmPattern()), null);
        out.accept(Apotheosis.loc("infusion/potion_charm"), (Recipe)new CharmInfusionRecipe(new EnchantingStatRegistry.Stats(15.0f, 100.0f, 8.5f, 32.5f, 0), new EnchantingStatRegistry.Stats(15.0f, 100.0f, 13.5f, 37.5f, 0)), null);
        this.addShaped(new ItemStack(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, 2), 3, 3, new Object[]{null, Apoth.Items.COMMON_MATERIAL, null, Apoth.Items.STONE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.STONE, Apoth.Items.STONE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.STONE});
        this.addShaped(new ItemStack(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, 2), 3, 3, new Object[]{null, Apoth.Items.UNCOMMON_MATERIAL, null, Apoth.Items.STONE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.STONE, Apoth.Items.STONE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.STONE});
        this.addShaped(new ItemStack(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, 2), 3, 3, new Object[]{null, Apoth.Items.RARE_MATERIAL, null, Apoth.Items.STONE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.STONE, Apoth.Items.STONE, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.STONE});
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.STONE_SWORD, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_SWORD);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.STONE_PICKAXE, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_PICKAXE);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.STONE_AXE, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_AXE);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.STONE_SHOVEL, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_SHOVEL);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.STONE_HOE, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_HOE);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.CHAINMAIL_HELMET, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_HELMET);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.CHAINMAIL_CHESTPLATE, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_CHESTPLATE);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.CHAINMAIL_LEGGINGS, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_LEGGINGS);
        this.addSizedUpgrade(Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.CHAINMAIL_BOOTS, (TagKey<Item>)Tags.Items.INGOTS_IRON, 4, Apoth.Items.IRON_BOOTS);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_SWORD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_SWORD);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_PICKAXE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_PICKAXE);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_AXE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_AXE);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_SHOVEL, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_SHOVEL);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_HOE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_HOE);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_HELMET, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_HELMET);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_CHESTPLATE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_CHESTPLATE);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_LEGGINGS, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_LEGGINGS);
        this.addSizedUpgrade(Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.IRON_BOOTS, (TagKey<Item>)Tags.Items.INGOTS_GOLD, 4, Apoth.Items.GOLDEN_BOOTS);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_SWORD, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_SWORD);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_PICKAXE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_PICKAXE);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_AXE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_AXE);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_SHOVEL, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_SHOVEL);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_HOE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_HOE);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_HELMET, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_HELMET);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_CHESTPLATE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_CHESTPLATE);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_LEGGINGS, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_LEGGINGS);
        this.addSizedUpgrade(Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLDEN_BOOTS, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, 4, Apoth.Items.DIAMOND_BOOTS);
    }

    private ShapedRecipePattern charmPattern() {
        HashMap<Character, Ingredient> key = new HashMap<Character, Ingredient>();
        key.put(Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{Apoth.Items.BLAZE_POWDER}));
        key.put(Character.valueOf('P'), Ingredient.of((ItemLike[])new ItemLike[]{Apoth.Items.POTION}));
        return ShapedRecipePattern.of(key, (String[])new String[]{"BBB", "PPP", "BBB"});
    }

    private void addPurityUpgrade(Purity purity, int gemDust, List<Holder<Item>> materials, int zerothMatCost) {
        SizedIngredient dustIng = SizedIngredient.of((ItemLike)((ItemLike)Apoth.Items.GEM_DUST.value()), (int)gemDust);
        ArrayList<SizedIngredient> materialIngs = new ArrayList<SizedIngredient>();
        int matAmount = zerothMatCost;
        for (Holder<Item> mat : materials) {
            materialIngs.add(SizedIngredient.of((ItemLike)((ItemLike)mat.value()), (int)matAmount));
            matAmount /= 3;
        }
        PurityUpgradeRecipe recipe = new PurityUpgradeRecipe(purity, List.of(dustIng), materialIngs);
        this.recipeOutput.accept(Apotheosis.loc("gem_cutting/" + purity.name().toLowerCase(Locale.ROOT)), (Recipe)recipe, null);
    }

    @SafeVarargs
    private void addReforging(String rarity, int mats, int sigils, int levels, Holder<Block> ... tables) {
        DynamicHolder lRarity = RarityRegistry.INSTANCE.holder(Apotheosis.loc(rarity));
        this.recipeOutput.accept(Apotheosis.loc("reforging/" + rarity), (Recipe)new ReforgingRecipe((DynamicHolder<LootRarity>)lRarity, mats, sigils, levels, (HolderSet<Block>)HolderSet.direct(tables)), null);
    }

    private void addGemSalvaging(Purity purity, int min, int max) {
        Ingredient input = new Ingredient((ICustomIngredient)new GemIngredient(purity));
        SalvagingRecipe.OutputData output = new SalvagingRecipe.OutputData(new ItemStack(Apoth.Items.GEM_DUST), min, max);
        this.addSalvaging("gem/" + purity.getSerializedName(), input, output);
    }

    private void addAffixSalvaging(String rarity, Holder<Item> material) {
        Ingredient input = new Ingredient((ICustomIngredient)new AffixItemIngredient((DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(Apotheosis.loc(rarity))));
        SalvagingRecipe.OutputData output = new SalvagingRecipe.OutputData(new ItemStack(material), 1, 4);
        this.addSalvaging("affix_item/" + rarity, input, output);
    }

    private void addOtherSalvaging(String path, SalvagingRecipe.OutputData output, Item ... inputs) {
        this.addSalvaging("salvaging/other/" + path, Ingredient.of((ItemLike[])inputs), List.of(output));
    }

    private void addSalvaging(String path, Ingredient input, SalvagingRecipe.OutputData output) {
        this.addSalvaging("salvaging/" + path, input, List.of(output));
    }

    private void addSalvaging(String path, Ingredient input, List<SalvagingRecipe.OutputData> outputs) {
        this.recipeOutput.accept(Apotheosis.loc(path), (Recipe)new SalvagingRecipe(input, outputs), null);
    }

    private void addSockets(String path, Ingredient input, int maxSockets) {
        this.recipeOutput.accept(Apotheosis.loc(path), (Recipe)new AddSocketsRecipe(input, maxSockets), null);
    }

    private static <T extends ItemLike> Ingredient ingredient(Holder<T> holder) {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)holder.value()});
    }

    private void addSizedUpgrade(Holder<Item> template, Item base, TagKey<Item> addition, int size, Item output) {
        String path1 = BuiltInRegistries.ITEM.getKey((Object)base).getPath();
        String path2 = BuiltInRegistries.ITEM.getKey((Object)output).getPath();
        this.recipeOutput.accept(Apotheosis.loc("smithing/upgrade_%s_to_%s".formatted(path1, path2)), (Recipe)new SizedUpgradeRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)template.value()}), Ingredient.of((ItemLike[])new ItemLike[]{base}), SizedIngredient.of(addition, (int)size), output.getDefaultInstance()), null);
    }
}

