/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.client.BeamRenderer;
import dev.shadowsoffire.apotheosis.client.ShadowRenderer;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRenderData;
import dev.shadowsoffire.apotheosis.particle.RarityParticleData;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="apotheosis", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class AffixItemEffectRenderer {
    @SubscribeEvent
    public static void render(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS || !AdventureConfig.enableAffixItemEffects) {
            return;
        }
        PoseStack pose = e.getPoseStack();
        LocalPlayer p = Minecraft.getInstance().player;
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        for (Entity ent : Minecraft.getInstance().level.entitiesForRendering()) {
            if (!(ent instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)ent;
            ItemStack stack = item.getItem();
            DynamicHolder<LootRarity> rarityHolder = AffixHelper.getRarity(stack);
            if (!rarityHolder.isBound() || !item.onGround()) {
                item.setData(Apoth.Attachments.AFFIX_EFFECT_RENDER_STARTED, (Object)false);
                continue;
            }
            if (!((Boolean)item.getData(Apoth.Attachments.AFFIX_EFFECT_RENDER_STARTED)).booleanValue()) {
                item.setData(Apoth.Attachments.AFFIX_EFFECT_RENDER_STARTED, (Object)true);
                item.setData(Apoth.Attachments.AFFIX_EFFECT_START_TIME, (Object)item.tickCount);
            }
            LootRarity rarity = (LootRarity)rarityHolder.get();
            RarityRenderData renderData = rarity.renderData();
            int color = rarity.color().getValue();
            float partials = e.getPartialTick().getGameTimeDeltaPartialTick(false);
            float progress = Mth.clamp((float)((float)(item.tickCount - (Integer)item.getData(Apoth.Attachments.AFFIX_EFFECT_START_TIME)) + partials), (float)0.0f, (float)15.0f) / 15.0f;
            Vec3 vec = e.getCamera().getPosition();
            double x = Mth.lerp((double)partials, (double)item.xOld, (double)item.getX());
            double y = Mth.lerp((double)partials, (double)item.yOld, (double)item.getY());
            double z = Mth.lerp((double)partials, (double)item.zOld, (double)item.getZ());
            pose.pushPose();
            pose.translate(x - vec.x, y - vec.y, z - vec.z);
            pose.pushPose();
            pose.translate(-item.getBbWidth() * 2.0f, 0.0f, -item.getBbWidth() * 2.0f);
            float beamHeight = renderData.beamHeight();
            float beamRadius = renderData.beamRadius();
            float glowRadius = renderData.glowRadius();
            boolean alphaZero = false;
            int alphaLow = 31;
            int alphaMax = 159;
            float height = beamHeight * progress;
            if (beamHeight > 0.0f) {
                BeamRenderer.renderBeaconBeam(pose, (MultiBufferSource)buf, renderData.beamTexture(), renderData.glowTexture(), partials, 1.0f, p.level().getGameTime(), 0.0f, Math.min(height, 0.5f), AffixItemEffectRenderer.color(0, color), AffixItemEffectRenderer.color(31, color), beamRadius, glowRadius);
                BeamRenderer.renderBeaconBeam(pose, (MultiBufferSource)buf, renderData.beamTexture(), renderData.glowTexture(), partials, 1.0f, p.level().getGameTime(), 0.5f, Math.clamp(height -= 0.5f, 0.0f, 0.5f), AffixItemEffectRenderer.color(31, color), AffixItemEffectRenderer.color(159, color), beamRadius, glowRadius);
                BeamRenderer.renderBeaconBeam(pose, (MultiBufferSource)buf, renderData.beamTexture(), renderData.glowTexture(), partials, 1.0f, p.level().getGameTime(), 1.0f, Math.clamp(height -= 0.5f, 0.0f, 0.5f), AffixItemEffectRenderer.color(159, color), AffixItemEffectRenderer.color(159, color), beamRadius, glowRadius);
                BeamRenderer.renderBeaconBeam(pose, (MultiBufferSource)buf, renderData.beamTexture(), renderData.glowTexture(), partials, 1.0f, p.level().getGameTime(), 1.5f, Math.clamp(height -= 0.5f, 0.0f, beamHeight), AffixItemEffectRenderer.color(159, color), AffixItemEffectRenderer.color(0, color), beamRadius, glowRadius);
            }
            pose.popPose();
            RarityRenderData.ShadowData data = renderData.shadow();
            ShadowRenderer.renderShadow(pose, (MultiBufferSource)buf, (Entity)item, partials, (LevelReader)item.level(), data, FastColor.ARGB32.color((int)data.alpha(), (int)color));
            pose.popPose();
            if (!renderData.particle().enabled()) continue;
            int delay = (Integer)item.getData(Apoth.Attachments.AFFIX_EFFECT_NEXT_PARTICLE_TIME);
            if (progress != 1.0f || item.tickCount - delay <= 0) continue;
            RarityParticleData opt = new RarityParticleData((float)FastColor.ARGB32.red((int)color) / 255.0f, (float)FastColor.ARGB32.green((int)color) / 255.0f, (float)FastColor.ARGB32.blue((int)color) / 255.0f);
            RandomSource rand = item.getRandom();
            double spread = 0.1;
            item.level().addParticle((ParticleOptions)opt, item.getX() - spread + rand.nextDouble() * 2.0 * spread, item.getY(), item.getZ() - spread + rand.nextDouble() * 2.0 * spread, 0.0, 0.03 + 0.005 * rand.nextGaussian(), 0.0);
            item.setData(Apoth.Attachments.AFFIX_EFFECT_NEXT_PARTICLE_TIME, (Object)(item.tickCount + 10 + rand.nextInt(15)));
        }
    }

    private static int color(int alpha, int color) {
        return FastColor.ARGB32.color((int)alpha, (int)color);
    }
}

