/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.augmenting;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.augmenting.AugmentingMenu;
import dev.shadowsoffire.apotheosis.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.client.DropDownList;
import dev.shadowsoffire.apotheosis.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class AugmentingScreen
extends AdventureContainerScreen<AugmentingMenu> {
    public static final ResourceLocation TEXTURE = Apotheosis.loc("textures/gui/augmenting.png");
    public static final int ALTERNATIVE_TEXT_WIDTH = 150;
    public static final int ALTERNATIVE_MAX_LINES = 15;
    protected ItemStack lastMainItem = ItemStack.EMPTY;
    protected int lastSelection = -1;
    protected List<AffixInstance> currentItemAffixes = Collections.emptyList();
    protected int alternativePage = -1;
    protected List<List<FormattedText>> alternativePages = Collections.emptyList();
    protected int alternativeXPos = 0;
    protected int alternativeWidth = 0;
    protected AffixDropList list;
    protected SimpleTexButton upgradeBtn;
    protected SimpleTexButton rerollBtn;
    protected final AttributeTooltipContext tooltipCtx;

    public AugmentingScreen(AugmentingMenu menu, Inventory inv, Component pTitle) {
        super(menu, inv, pTitle);
        this.imageHeight = 222;
        this.tooltipCtx = AttributeTooltipContext.of((Player)inv.player, (Item.TooltipContext)Item.TooltipContext.of((Level)inv.player.level()), (TooltipFlag)ApothicAttributes.getTooltipFlag());
    }

    protected void init() {
        super.init();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int selected = this.getSelectedAffix();
        this.list = (AffixDropList)this.addRenderableWidget((GuiEventListener)new AffixDropList(left + 39, top + 17, 123, 14, (Component)Component.empty(), this.currentItemAffixes, 6));
        this.list.setSelected(selected);
        this.upgradeBtn = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)new FatTexButton(left + 60, top + 111, 29, 13, 186, 135, btn -> {
            if (this.getSelectedAffix() != -1) {
                this.minecraft.gameMode.handleInventoryButtonClick(((AugmentingMenu)this.menu).containerId, 0 | this.getSelectedAffix() << 1);
            }
        }, (Component)Component.translatable((String)"button.apotheosis.augmenting.upgrade")));
        this.rerollBtn = (SimpleTexButton)this.addRenderableWidget((GuiEventListener)new FatTexButton(left + 112, top + 111, 29, 13, 223, 135, btn -> {
            if (this.getSelectedAffix() != -1) {
                this.minecraft.gameMode.handleInventoryButtonClick(((AugmentingMenu)this.menu).containerId, 1 | this.getSelectedAffix() << 1);
            }
        }, (Component)Component.translatable((String)"button.apotheosis.augmenting.reroll")));
    }

    protected void renderBg(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
        AffixInstance inst;
        this.updateCachedState();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int xCenter = (this.width - this.imageWidth) / 2;
        int yCenter = (this.height - this.imageHeight) / 2;
        gfx.blit(TEXTURE, xCenter, yCenter, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 307);
        int selected = this.getSelectedAffix();
        if (selected != -1 && !this.list.isOpen()) {
            inst = this.currentItemAffixes.get(selected);
            Component comp = inst.getAugmentingText(this.tooltipCtx);
            List split = this.font.split((FormattedText)comp, 117);
            for (int i = 0; i < split.size(); ++i) {
                gfx.drawString(this.font, (FormattedCharSequence)split.get(i), left + 43, top + 40 + i * 11, ChatFormatting.YELLOW.getColor().intValue(), true);
            }
            int bgColor = -267386864;
            int borderColor = -13220529;
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gfx, (int)(left + 42), (int)(top + 39), (int)117, (int)65, (int)0, (int)bgColor, (int)bgColor, (int)borderColor, (int)borderColor);
        } else {
            int bgColor = -1441787888;
            int borderColor = -1439283889;
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gfx, (int)(left + 42), (int)(top + 39), (int)117, (int)65, (int)0, (int)bgColor, (int)bgColor, (int)borderColor, (int)borderColor);
        }
        if (selected != -1 && this.rerollBtn.isHovered() && this.rerollBtn.isActive() && this.alternativePage != -1) {
            List<FormattedText> page = this.alternativePages.get(this.alternativePage);
            List list = page.stream().map(arg_0 -> ((Language)Language.getInstance()).getVisualOrder(arg_0)).map(ClientTooltipComponent::create).collect(Collectors.toCollection(Lists::newArrayList));
            if (this.alternativePages.size() > 1) {
                list.set(list.size() - 2, new FakeWidthComponent(this.alternativeWidth));
            }
            gfx.renderTooltipInternal(this.font, list, this.alternativeXPos, this.getGuiTop() + 33, DefaultTooltipPositioner.INSTANCE);
        }
        if (selected != -1 && this.upgradeBtn.isActive() && this.upgradeBtn.isHovered()) {
            inst = this.currentItemAffixes.get(selected);
            AffixInstance upgraded = new AffixInstance(inst.affix(), Math.min(1.0f, inst.level() + 0.25f), inst.rarity(), inst.stack());
            ArrayList<MutableComponent> altText = new ArrayList<MutableComponent>();
            altText.add(Component.translatable((String)"text.apotheosis.upgraded_form").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}));
            altText.add(Component.translatable((String)"%s", (Object[])new Object[]{upgraded.getAugmentingText(this.tooltipCtx)}).withStyle(ChatFormatting.YELLOW));
            this.drawOnLeft(gfx, altText, top + 33, 150);
        }
    }

    protected void updateCachedState() {
        int selected;
        ItemStack mainItem = ((AugmentingMenu)this.menu).getMainItem();
        if (!ItemStack.isSameItemSameComponents((ItemStack)mainItem, (ItemStack)this.lastMainItem)) {
            List<AffixInstance> newAffixes = AugmentingMenu.computeItemAffixes(mainItem);
            if (ItemStack.isSameItem((ItemStack)mainItem, (ItemStack)this.lastMainItem) && this.currentItemAffixes.size() == newAffixes.size()) {
                this.list.setEntries(newAffixes);
                this.list.setSelected(this.lastSelection);
            } else {
                this.list.setEntries(newAffixes);
            }
            this.currentItemAffixes = newAffixes;
            this.lastMainItem = mainItem.copy();
            this.computeAlternatives(this.list.getSelected());
        }
        if (this.lastSelection != this.list.getSelected()) {
            this.lastSelection = this.list.getSelected();
            this.computeAlternatives(this.lastSelection);
        }
        if ((selected = this.getSelectedAffix()) == -1) {
            MutableComponent comp = Component.translatable((String)"button.apotheosis.augmenting.no_selection").withStyle(ChatFormatting.RED);
            this.upgradeBtn.active = false;
            this.upgradeBtn.setInactiveMessage((Component)comp);
            this.rerollBtn.active = false;
            this.rerollBtn.setInactiveMessage((Component)comp);
        } else {
            this.upgradeBtn.active = true;
            this.rerollBtn.active = true;
            AffixInstance current = this.currentItemAffixes.get(selected);
            if (current.level() >= 1.0f) {
                this.upgradeBtn.active = false;
                this.upgradeBtn.setInactiveMessage((Component)Component.translatable((String)"button.apotheosis.augmenting.max_level").withStyle(ChatFormatting.RED));
            }
            if (this.alternativePages.isEmpty()) {
                this.rerollBtn.active = false;
                this.rerollBtn.setInactiveMessage((Component)Component.translatable((String)"button.apotheosis.augmenting.no_alternatives").withStyle(ChatFormatting.RED));
            }
            if (this.upgradeBtn.isActive() && !((AugmentingMenu)this.menu).hasUpgradeCost() && !((AugmentingMenu)this.menu).player.isCreative()) {
                this.upgradeBtn.active = false;
                this.upgradeBtn.setInactiveMessage(CommonComponents.EMPTY);
            }
            if (this.rerollBtn.isActive() && !((AugmentingMenu)this.menu).hasRerollCost() && !((AugmentingMenu)this.menu).player.isCreative()) {
                this.rerollBtn.active = false;
                this.rerollBtn.setInactiveMessage(CommonComponents.EMPTY);
            }
        }
    }

    protected void computeAlternatives(int selected) {
        if (selected == -1) {
            this.alternativePages = Collections.emptyList();
            this.alternativePage = -1;
            return;
        }
        AffixInstance current = this.currentItemAffixes.get(selected);
        List<DynamicHolder<Affix>> alternatives = LootController.getAlternativeAffixes(this.lastMainItem, current.getRarity(), current.affix()).toList();
        if (alternatives.isEmpty()) {
            this.alternativePages = Collections.emptyList();
            this.alternativePage = -1;
        } else {
            StringSplitter splitter = this.font.getSplitter();
            int maxWidth = 0;
            MutableComponent heading = Component.translatable((String)"text.apotheosis.potential_rerolls").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
            ArrayList<List<FormattedText>> pages = new ArrayList<List<FormattedText>>();
            ArrayList<Object> page = new ArrayList<Object>();
            page.add(heading);
            boolean first = true;
            for (DynamicHolder<Affix> afx : alternatives) {
                AffixInstance inst = new AffixInstance(afx, current.level(), current.rarity(), current.stack());
                Component augTxt = inst.getAugmentingText(this.tooltipCtx);
                List split = splitter.splitLines((FormattedText)Component.translatable((String)"%s", (Object[])new Object[]{augTxt}).withStyle(ChatFormatting.YELLOW), 150, augTxt.getStyle());
                maxWidth = Math.max(maxWidth, split.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).max(Integer::compare).get());
                if (page.size() + split.size() + 1 > 15) {
                    pages.add(page);
                    page = new ArrayList();
                    page.add(heading);
                    page.addAll(split);
                } else {
                    if (!first) {
                        page.add(CommonComponents.SPACE);
                    }
                    page.addAll(split);
                    first = false;
                }
                if (afx != alternatives.get(alternatives.size() - 1)) continue;
                pages.add(page);
            }
            this.alternativePage = 0;
            this.alternativePages = pages;
            this.alternativeXPos = this.getGuiLeft() - 16 - maxWidth;
            this.alternativeWidth = maxWidth;
            int pages2 = this.alternativePages.size();
            if (pages2 > 1) {
                for (int i = 0; i < pages2; ++i) {
                    List<FormattedText> page2 = this.alternativePages.get(i);
                    page2.add((FormattedText)CommonComponents.SPACE);
                    page2.add((FormattedText)Component.translatable((String)"text.apotheosis.alternative_page", (Object[])new Object[]{i + 1, pages2}).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    protected int getSelectedAffix() {
        return this.list == null ? -1 : this.list.getSelected();
    }

    public static void handleRerollResult(DynamicHolder<Affix> newAffix) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AugmentingScreen) {
            AugmentingScreen scn = (AugmentingScreen)screen;
            scn.updateCachedState();
            for (int i = 0; i < scn.currentItemAffixes.size(); ++i) {
                AffixInstance inst = scn.currentItemAffixes.get(i);
                if (!inst.affix().equals(newAffix)) continue;
                scn.list.setSelected(i);
                return;
            }
        }
    }

    public class AffixDropList
    extends DropDownList<AffixInstance> {
        public AffixDropList(int x, int y, int width, int height, Component narrationMsg, List<AffixInstance> entries, int maxDisplayedEntries) {
            super(x, y, width, height, narrationMsg, entries, maxDisplayedEntries);
        }

        @Override
        protected void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
            gfx.pose().pushPose();
            gfx.pose().translate(0.0f, 0.0f, 100.0f);
            if (this.entries.isEmpty()) {
                gfx.blit(TEXTURE, this.getX(), this.getY(), 0.0f, 267.0f, this.width, this.baseHeight, 256, 307);
            }
            super.renderWidget(gfx, mouseX, mouseY, partialTick);
            int hovered = this.getHoveredSlot(mouseX, mouseY);
            if (this.isOpen && hovered != -1) {
                AffixInstance inst = (AffixInstance)this.entries.get(hovered);
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                list.add(inst.getName(true).copy().withStyle(Style.EMPTY.withColor(0xFFFF80).withUnderlined(Boolean.valueOf(true))));
                list.add(Component.translatable((String)"%s", (Object[])new Object[]{inst.getAugmentingText(AugmentingScreen.this.tooltipCtx)}).withStyle(ChatFormatting.YELLOW));
                AugmentingScreen.this.drawOnLeft(gfx, list, AugmentingScreen.this.getGuiTop() + 33, 150);
            }
            gfx.blit(TEXTURE, this.getX() + this.width - 15, this.getY(), (float)(123 + (this.isOpen ? 15 : 0)), 239.0f, 15, 14, 256, 307);
            gfx.pose().popPose();
        }

        @Override
        protected void renderEntry(GuiGraphics gfx, int x, int y, int mouseX, int mouseY, AffixInstance entry) {
            int idx;
            int hovered = this.getHoveredSlot(mouseX, mouseY);
            gfx.blit(TEXTURE, x, y, 0.0f, (float)(239 + (hovered == (idx = this.entries.indexOf(entry)) ? this.baseHeight : 0)), this.width, this.baseHeight, 256, 307);
            Component name = entry.getName(true);
            if (entry.level() >= 1.0f) {
                name = ApothMiscUtil.starPrefix(name);
            }
            gfx.drawString(AugmentingScreen.this.font, name, x + 2, y + 3, 0xFFFF80);
        }
    }

    public class FatTexButton
    extends SimpleTexButton {
        private final Component sigilName;

        public FatTexButton(int x, int y, int width, int height, int u, int v, Button.OnPress press, Component message) {
            super(x, y, width, height, u, v, TEXTURE, 256, 307, press, message);
            this.sigilName = Component.translatable((String)"item.apotheosis.sigil_of_enhancement").withStyle(ChatFormatting.YELLOW);
        }

        @Override
        public void renderWidget(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
            int yTex = this.yTexStart - 2;
            if (!this.isActive()) {
                yTex += this.height + 4;
            } else if (this.isHovered()) {
                yTex += (this.height + 4) * 2;
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            gfx.blit((ResourceLocation)this.texture.orThrow(), this.getX() - 2, this.getY() - 2, (float)(this.xTexStart - 2), (float)yTex, this.width + 4, this.height + 4, this.textureWidth, this.textureHeight);
            if (this.isHovered()) {
                this.renderToolTip(gfx, pMouseX, pMouseY);
            }
        }

        @Override
        public void renderToolTip(GuiGraphics gfx, int pMouseX, int pMouseY) {
            if (this.getMessage() != CommonComponents.EMPTY && this.isHovered()) {
                Component primary = this.getMessage();
                if (!this.active) {
                    primary = primary.copy().withStyle(ChatFormatting.GRAY);
                }
                int sigilCost = this == AugmentingScreen.this.rerollBtn ? AdventureConfig.rerollSigilCost : AdventureConfig.upgradeSigilCost;
                int levelCost = this == AugmentingScreen.this.rerollBtn ? AdventureConfig.rerollLevelCost : AdventureConfig.upgradeLevelCost;
                ArrayList<Object> tooltips = new ArrayList<Object>();
                tooltips.add(primary);
                MutableComponent sigilCostMsg = Apotheosis.lang("button", "augmenting.upgrade.cost", sigilCost, this.sigilName);
                MutableComponent levelCostMsg = Apotheosis.lang("button", "augmenting.upgrade.exp_cost", levelCost);
                if (this.isActive()) {
                    tooltips.add(sigilCostMsg);
                    tooltips.add(levelCostMsg);
                } else if (!this.inactiveMessage.isEmpty()) {
                    tooltips.addAll(this.inactiveMessage);
                } else {
                    if (((AugmentingMenu)AugmentingScreen.this.menu).getSigils().getCount() < sigilCost) {
                        sigilCostMsg.withStyle(ChatFormatting.RED);
                    } else {
                        sigilCostMsg.withStyle(ChatFormatting.GRAY);
                    }
                    if (Minecraft.getInstance().player.experienceLevel < levelCost) {
                        levelCostMsg.withStyle(ChatFormatting.RED);
                    } else {
                        levelCostMsg.withStyle(ChatFormatting.GRAY);
                    }
                    tooltips.add(sigilCostMsg);
                    tooltips.add(levelCostMsg);
                }
                gfx.renderComponentTooltip(Minecraft.getInstance().font, tooltips, pMouseX, pMouseY);
            }
        }

        public boolean mouseScrolled(double pMouseX, double pMouseY, double scrollX, double scrollY) {
            if (this == AugmentingScreen.this.rerollBtn && this.isActive() && this.isHovered()) {
                int change = scrollY < 0.0 ? 1 : -1;
                int page = AugmentingScreen.this.alternativePage;
                AugmentingScreen.this.alternativePage = page = Math.floorMod(page + change, AugmentingScreen.this.alternativePages.size());
                return true;
            }
            return super.mouseScrolled(pMouseX, pMouseY, scrollX, scrollY);
        }
    }

    public record FakeWidthComponent(int width) implements ClientTooltipComponent
    {
        public int getHeight() {
            return 9;
        }

        public int getWidth(Font pFont) {
            return this.width;
        }
    }
}

