/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.CachedObject;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class AffixHelper {
    public static final ResourceLocation AFFIX_CACHED_OBJECT = Apotheosis.loc("affixes");
    public static final String SOURCE_WEAPON = "apoth.source_weapon";

    public static void applyAffix(ItemStack stack, AffixInstance inst) {
        ItemAffixes.Builder builder = ((ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY)).toBuilder();
        builder.put(inst.affix(), inst.level());
        AffixHelper.setAffixes(stack, builder.build());
    }

    public static void setAffixes(ItemStack stack, ItemAffixes affixes) {
        stack.set(Apoth.Components.AFFIXES, (Object)affixes);
    }

    public static void setName(ItemStack stack, Component name) {
        stack.set(Apoth.Components.AFFIX_NAME, (Object)name.copy());
    }

    @Nullable
    public static Component getName(ItemStack stack) {
        return (Component)stack.get(Apoth.Components.AFFIX_NAME);
    }

    @Nullable
    public static Component getModifiedStackName(ItemStack stack, Component currentName) {
        if (stack.has(Apoth.Components.AFFIX_NAME)) {
            Component hidden;
            if (FMLEnvironment.dist.isClient() && (hidden = ClientAccess.getHiddenAffixName(currentName)) != null) {
                return hidden;
            }
            try {
                Component component = AffixHelper.getName(stack);
                TranslatableContents contents = AffixHelper.copyContents(component);
                int idx = "misc.apotheosis.affix_name.four".equals(contents.getKey()) ? 2 : 1;
                contents.getArgs()[idx] = currentName;
                MutableComponent ret = MutableComponent.create((ComponentContents)contents).withStyle(component.getStyle());
                for (Component sibling : component.getSiblings()) {
                    ret.append(sibling);
                }
                return ret;
            }
            catch (Exception exception) {
                stack.remove(Apoth.Components.AFFIX_NAME);
            }
        }
        return null;
    }

    public static Map<DynamicHolder<Affix>, AffixInstance> getAffixes(ItemStack stack) {
        if (AffixRegistry.INSTANCE.getValues().isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)CachedObject.CachedObjectSource.getOrCreate((ItemStack)stack, (ResourceLocation)AFFIX_CACHED_OBJECT, AffixHelper::getAffixesImpl, (ToIntFunction)CachedObject.hashComponents((DataComponentType[])new DataComponentType[]{Apoth.Components.AFFIXES, Apoth.Components.RARITY}));
    }

    public static Map<DynamicHolder<Affix>, AffixInstance> getAffixesImpl(ItemStack stack) {
        if (stack.isEmpty()) {
            return Collections.emptyMap();
        }
        DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(stack);
        if (!rarity.isBound()) {
            return Collections.emptyMap();
        }
        HashMap<DynamicHolder, AffixInstance> map = new HashMap<DynamicHolder, AffixInstance>();
        ItemAffixes affixes = (ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY);
        if (!affixes.isEmpty()) {
            LootCategory cat = LootCategory.forItem(stack);
            for (DynamicHolder affix : affixes.keySet()) {
                if (!affix.isBound() || !((Affix)affix.get()).canApplyTo(stack, cat, (LootRarity)rarity.get())) continue;
                float lvl = affixes.getLevel((DynamicHolder<Affix>)affix);
                map.put(affix, new AffixInstance((DynamicHolder<Affix>)affix, lvl, rarity, stack));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static Stream<AffixInstance> streamAffixes(ItemStack stack) {
        return AffixHelper.getAffixes(stack).values().stream().filter(AffixInstance::isValid);
    }

    public static Stream<AffixInstance> streamAffixes(Projectile proj) {
        return AffixHelper.getAffixes(proj).values().stream().filter(AffixInstance::isValid);
    }

    public static boolean hasAffixes(ItemStack stack) {
        return !AffixHelper.getAffixes(stack).isEmpty();
    }

    public static void setRarity(ItemStack stack, LootRarity rarity) {
        stack.set(Apoth.Components.RARITY, (Object)RarityRegistry.INSTANCE.holder(rarity));
    }

    public static void copyToProjectile(ItemStack stack, Entity entity) {
        ItemAffixes affixes = (ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY);
        ItemContainerContents gems = (ItemContainerContents)stack.getOrDefault(Apoth.Components.SOCKETED_GEMS, (Object)ItemContainerContents.EMPTY);
        if (!affixes.isEmpty() || gems.nonEmptyStream().findAny().isPresent()) {
            entity.getPersistentData().put(SOURCE_WEAPON, stack.save((HolderLookup.Provider)entity.level().registryAccess()));
        }
    }

    public static ItemStack getSourceWeapon(Entity entity) {
        if (entity.getPersistentData().contains(SOURCE_WEAPON)) {
            return ItemStack.parseOptional((HolderLookup.Provider)entity.level().registryAccess(), (CompoundTag)entity.getPersistentData().getCompound(SOURCE_WEAPON));
        }
        return ItemStack.EMPTY;
    }

    public static Map<DynamicHolder<Affix>, AffixInstance> getAffixes(Projectile proj) {
        ItemStack stack = AffixHelper.getSourceWeapon((Entity)proj);
        return AffixHelper.getAffixes(stack);
    }

    public static DynamicHolder<LootRarity> getRarity(ItemStack stack) {
        return (DynamicHolder)stack.getOrDefault(Apoth.Components.RARITY, (Object)RarityRegistry.INSTANCE.emptyHolder());
    }

    public static Collection<DynamicHolder<Affix>> byType(AffixType type) {
        return AffixRegistry.INSTANCE.getTypeMap().get((Object)type);
    }

    public static void applyMalice(Player player, ItemStack stack) {
        int secondIndex;
        ItemAffixes affixes = (ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY);
        if (affixes.isEmpty() || affixes.size() < 2) {
            return;
        }
        int seed = player.getPersistentData().getInt("apoth_reforge_seed");
        XoroshiroRandomSource rand = new XoroshiroRandomSource((long)seed);
        ItemAffixes.Builder builder = affixes.toBuilder();
        ArrayList<DynamicHolder<Affix>> afxList = new ArrayList<DynamicHolder<Affix>>((Collection<DynamicHolder<Affix>>)affixes.keySet());
        int size = afxList.size();
        int firstIndex = rand.nextInt(size);
        while ((secondIndex = rand.nextInt(size)) == firstIndex) {
        }
        DynamicHolder buffed = (DynamicHolder)afxList.get(firstIndex);
        DynamicHolder removed = (DynamicHolder)afxList.get(secondIndex);
        builder.upgrade((DynamicHolder<Affix>)buffed, 1.5f);
        float oldLevel = builder.getLevel((DynamicHolder<Affix>)removed);
        builder.remove((DynamicHolder<Affix>)removed);
        AffixHelper.setAffixes(stack, builder.build());
        stack.set(Apoth.Components.TOUCHED_BY_MALICE, (Object)true);
        player.getPersistentData().putInt("apoth_reforge_seed", player.getRandom().nextInt());
        AttributeTooltipContext ctx = AttributeTooltipContext.of((Player)player, (Item.TooltipContext)Item.TooltipContext.of((Level)player.level()), (TooltipFlag)ApothicAttributes.getTooltipFlag());
        AffixInstance buff = new AffixInstance((DynamicHolder<Affix>)buffed, 1.5f, AffixHelper.getRarity(stack), stack);
        AffixInstance rem = new AffixInstance((DynamicHolder<Affix>)removed, oldLevel, AffixHelper.getRarity(stack), stack);
        MutableComponent buffedName = Component.translatable((String)"[%s]", (Object[])new Object[]{buff.getName(true)});
        buffedName.setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)buff.getAugmentingText(ctx))));
        MutableComponent removedName = Component.translatable((String)"[%s]", (Object[])new Object[]{rem.getName(true)});
        removedName.setStyle(Style.EMPTY.withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)rem.getAugmentingText(ctx))));
        MutableComponent msg = Apotheosis.lang("text", "malice_notice", buffedName, removedName);
        player.sendSystemMessage((Component)msg);
    }

    @Deprecated
    public static StepFunction step(float min, int steps, float step) {
        return new StepFunction(min, steps, step);
    }

    private static TranslatableContents copyContents(Component comp) {
        TranslatableContents tContents = (TranslatableContents)comp.getContents();
        Object[] args = tContents.getArgs();
        Object[] clone = Arrays.copyOf(args, args.length);
        return new TranslatableContents(tContents.getKey(), tContents.getFallback(), clone);
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        @Nullable
        private static Component getHiddenAffixName(Component currentName) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && WorldTier.isTutorialActive((Player)player)) {
                return Apotheosis.lang("text", "unidentified", currentName);
            }
            return null;
        }
    }
}

