/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block.entity;

import com.mojang.serialization.DynamicOps;
import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.init.ModRegistry;
import fuzs.spikyspikes.world.level.block.SpikeBlock;
import fuzs.spikyspikes.world.level.block.SpikeMaterial;
import fuzs.spikyspikes.world.level.block.entity.FakePlayerAttackHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SpikeBlockEntity
extends BlockEntity {
    public static final String ENCHANTMENTS_TAG = SpikySpikes.id("enchantments").toString();
    public static final String REPAIR_COST_TAG = SpikySpikes.id("repair_cost").toString();
    private ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    private int repairCost;

    public SpikeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.SPIKE_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
    }

    public static void attack(ServerLevel level, BlockPos pos, BlockState state, SpikeBlockEntity blockEntity, LivingEntity entity, SpikeMaterial material) {
        FakePlayerAttackHelper.attack((Entity)entity, level, pos, (Direction)state.getValue((Property)SpikeBlock.FACING), material.damageAmount(), blockEntity.enchantments, material.hurtsPlayers());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.enchantments = ItemEnchantments.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get(ENCHANTMENTS_TAG)).resultOrPartial().orElse(ItemEnchantments.EMPTY);
        if (tag.contains(REPAIR_COST_TAG, 3)) {
            this.repairCost = tag.getInt(REPAIR_COST_TAG);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.enchantments.isEmpty()) {
            tag.put(ENCHANTMENTS_TAG, (Tag)ItemEnchantments.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.enchantments).getOrThrow());
        }
        if (this.repairCost != 0) {
            tag.putInt(REPAIR_COST_TAG, this.repairCost);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.enchantments = (ItemEnchantments)componentInput.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        this.repairCost = (Integer)componentInput.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.STORED_ENCHANTMENTS, (Object)this.enchantments);
        components.set(DataComponents.REPAIR_COST, (Object)this.repairCost);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(ENCHANTMENTS_TAG);
        tag.remove(REPAIR_COST_TAG);
    }

    public boolean hasFoil() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }
}

