/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.FuelBurnTimesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.living.ComputeEnchantedLootBonusCallback;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.spikyspikes.config.ServerConfig;
import fuzs.spikyspikes.handler.SpikeLootingHandler;
import fuzs.spikyspikes.init.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpikySpikes
implements ModConstructor {
    public static final String MOD_ID = "spikyspikes";
    public static final String MOD_NAME = "Spiky Spikes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Spiky Spikes");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"spikyspikes").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        SpikySpikes.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ComputeEnchantedLootBonusCallback.EVENT.register(SpikeLootingHandler::onComputeEnchantedLootBonus);
    }

    public void onRegisterFuelBurnTimes(FuelBurnTimesContext context) {
        context.registerFuel(300, new ItemLike[]{(ItemLike)ModRegistry.WOODEN_SPIKE_BLOCK.value()});
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID, () -> new ItemStack((ItemLike)ModRegistry.DIAMOND_SPIKE_ITEM.value())).displayItems((itemDisplayParameters, output) -> {
            output.accept((ItemLike)ModRegistry.WOODEN_SPIKE_ITEM.value());
            output.accept((ItemLike)ModRegistry.STONE_SPIKE_ITEM.value());
            output.accept((ItemLike)ModRegistry.IRON_SPIKE_ITEM.value());
            output.accept((ItemLike)ModRegistry.GOLDEN_SPIKE_ITEM.value());
            output.accept((ItemLike)ModRegistry.DIAMOND_SPIKE_ITEM.value());
            output.accept((ItemLike)ModRegistry.NETHERITE_SPIKE_ITEM.value());
        }));
    }

    public ContentRegistrationFlags[] getContentRegistrationFlags() {
        return new ContentRegistrationFlags[]{ContentRegistrationFlags.COPY_RECIPES};
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

