/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.storage.expandedstoragedisk;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.setup.ESItems;
import edivad.extrastorage.storage.AdvancedFluidStorageVariant;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExpandedStorageDiskFluid
extends AbstractStorageContainerItem
implements UpgradeableStorageContainer {
    private final AdvancedFluidStorageVariant variant;
    private final Component helpText;

    public ExpandedStorageDiskFluid(AdvancedFluidStorageVariant variant) {
        super(new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = IdentifierUtil.createTranslation((String)"item", (String)"fluid_storage_disk.help", (Object[])new Object[]{IdentifierUtil.format((long)variant.getCapacityInBuckets())});
    }

    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(FluidResource.class).formatAmount(amount);
    }

    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return StorageTypes.FLUID.create(this.variant.getCapacity(), () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Items.INSTANCE.getStorageHousing(), count);
    }

    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)ESItems.FLUID_STORAGE_PART.get((Object)this.variant).get(), count);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

