/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.advancedexporter;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.exporter.ExporterData;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import edivad.extrastorage.advancedexporter.AdvancedExporterBlockEntity;
import edivad.extrastorage.setup.ESContainer;
import edivad.extrastorage.tools.AbstractAdvanceFilterContainerMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public class AdvancedExporterContainerMenu
extends AbstractAdvanceFilterContainerMenu<AdvancedExporterBlockEntity>
implements ExportingIndicatorListener {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"exporter.filter_help");
    private final ExportingIndicators indicators;

    public AdvancedExporterContainerMenu(int windowId, Inventory inventory, ExporterData data) {
        super((MenuType)ESContainer.ADVANCED_EXPORTER.get(), windowId, inventory.player, data.resourceContainerData(), UpgradeDestinations.EXPORTER, (Component)FILTER_HELP);
        this.indicators = new ExportingIndicators(data.exportingIndicators());
    }

    public AdvancedExporterContainerMenu(int windowId, Player player, AdvancedExporterBlockEntity exporter, ResourceContainer resourceContainer, UpgradeContainer upgradeContainer, ExportingIndicators indicators) {
        super((MenuType)ESContainer.ADVANCED_EXPORTER.get(), windowId, player, resourceContainer, upgradeContainer, exporter, (Component)FILTER_HELP);
        this.indicators = indicators;
    }

    public ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    public int getIndicators() {
        return this.indicators.size();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty((Property)new ClientProperty(PropertyTypes.FUZZY_MODE, (Object)false));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.SCHEDULING_MODE, (Object)SchedulingModeType.DEFAULT));
    }

    @Override
    protected void registerServerProperties(AdvancedExporterBlockEntity blockEntity) {
        this.registerProperty((Property)new ServerProperty(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((AdvancedExporterBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((AdvancedExporterBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.SCHEDULING_MODE, blockEntity::getSchedulingModeType, blockEntity::setSchedulingModeType));
    }

    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }
}

