/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.common.entities.PortalEntity;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class PortalProjectile
extends Projectile {
    private UUID portalGunUUID;
    private boolean isPrimaryType;
    private boolean isAdvanced;
    private NBTHelpers.PortalDestination portalDestination;
    private boolean hasSpawnedPortal = false;

    public PortalProjectile(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    public PortalProjectile(Level world, Player player, UUID portalGunUUID, boolean isPrimaryType, boolean isAdvanced) {
        this((EntityType<? extends Projectile>)((EntityType)Registration.PortalProjectile.get()), world);
        this.setOwner((Entity)player);
        this.setPos(player.getEyePosition());
        this.portalGunUUID = portalGunUUID;
        this.isPrimaryType = isPrimaryType;
        this.isAdvanced = isAdvanced;
    }

    public PortalProjectile(Level world, Player player, UUID portalGunUUID, boolean isPrimaryType, boolean isAdvanced, NBTHelpers.PortalDestination portalDestination) {
        this((EntityType<? extends Projectile>)((EntityType)Registration.PortalProjectile.get()), world);
        this.setOwner((Entity)player);
        this.setPos(player.getEyePosition());
        this.portalGunUUID = portalGunUUID;
        this.isPrimaryType = isPrimaryType;
        this.isAdvanced = isAdvanced;
        this.portalDestination = portalDestination;
    }

    public void tick() {
        super.tick();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0), (ClipContext.Block)ClipContext.Block.COLLIDER);
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.setPos(d0, d1, d2);
        if (this.isAdvanced) {
            if (this.tickCount > 5) {
                BlockPos blockPos = this.blockPosition();
                if (!this.level().getBlockState(blockPos).isAir() || !this.level().getBlockState(blockPos.below()).isAir()) {
                    blockPos = blockPos.relative(MiscHelpers.getPrimaryDirection(vec3).getOpposite());
                }
                Vec3 hitPos = Vec3.atCenterOf((Vec3i)blockPos);
                this.spawnAdvancedPortal(hitPos.x(), hitPos.y(), hitPos.z(), MiscHelpers.getPrimaryDirection(vec3).getOpposite(), blockPos);
            }
        } else if (this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        Vec3 hitPos = Vec3.atCenterOf((Vec3i)result.getBlockPos()).relative(result.getDirection(), 0.501);
        if (this.isAdvanced) {
            this.spawnAdvancedPortal(hitPos.x(), hitPos.y(), hitPos.z(), result.getDirection(), result.getBlockPos());
        } else {
            this.spawnPortal(hitPos.x(), hitPos.y(), hitPos.z(), result.getDirection(), result.getBlockPos());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected List<? extends PortalEntity> findMatchingPortal(MinecraftServer server, boolean isPrimaryType) {
        ArrayList returnList = new ArrayList();
        for (ServerLevel serverLevel : server.getAllLevels()) {
            List customEntities = serverLevel.getEntities((EntityTypeTest)Registration.PortalEntity.get(), k -> k.getPortalGunUUID().equals(this.portalGunUUID) && k.getIsPrimary() == isPrimaryType);
            if (customEntities.isEmpty()) continue;
            returnList.addAll(customEntities);
        }
        return returnList;
    }

    public void closeMyPortals(MinecraftServer server) {
        for (ServerLevel serverLevel : server.getAllLevels()) {
            List customEntities = serverLevel.getEntities((EntityTypeTest)Registration.PortalEntity.get(), k -> k.getPortalGunUUID().equals(this.portalGunUUID));
            for (PortalEntity entity : customEntities) {
                entity.setDying();
            }
        }
    }

    protected void clearMatchingPortal(MinecraftServer server) {
        List<? extends PortalEntity> matchingPortals = this.findMatchingPortal(server, this.isPrimaryType);
        for (PortalEntity portalEntity : matchingPortals) {
            if (portalEntity == null) continue;
            portalEntity.setDying();
        }
    }

    protected void linkPortals(MinecraftServer server, PortalEntity portal) {
        PortalEntity matchingPortal;
        List<? extends PortalEntity> matchingPortals = this.findMatchingPortal(server, !this.isPrimaryType);
        if (!matchingPortals.isEmpty() && (matchingPortal = matchingPortals.getFirst()) != null) {
            portal.setLinkedPortal(matchingPortal);
            matchingPortal.setLinkedPortal(portal);
        }
    }

    protected void linkPortals(PortalEntity source, PortalEntity destination) {
        source.setLinkedPortal(destination);
        destination.setLinkedPortal(source);
    }

    protected void spawnAdvancedPortal(double x, double y, double z, Direction direction, BlockPos hitPos) {
        if (this.hasSpawnedPortal) {
            return;
        }
        Level level = this.level();
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        if (this.getOwner() == null) {
            return;
        }
        if (!level.isClientSide) {
            boolean overlaps;
            PortalEntity source = new PortalEntity(level, direction, PortalProjectile.getPortalAlignment(this.getDeltaMovement()), this.portalGunUUID, this.isPrimaryType, true, this.getOwner().getUUID());
            if (direction.getAxis() != Direction.Axis.Y) {
                y -= 1.5;
                BlockState belowState = level.getBlockState(hitPos.relative(direction).below());
                if (!belowState.isAir()) {
                    y += 1.0;
                    BlockState aboveState = level.getBlockState(hitPos.relative(direction).above());
                    if (!aboveState.isAir()) {
                        this.discard();
                        return;
                    }
                }
            } else if (PortalProjectile.getPortalAlignment(this.getDeltaMovement()) == Direction.Axis.X) {
                x -= 0.5;
            } else {
                z -= 0.5;
            }
            source.setPos(x, y, z);
            source.refreshDimensions();
            AABB newBoundingBox = source.getBoundingBox();
            List existingPortals = level.getEntitiesOfClass(PortalEntity.class, newBoundingBox.inflate(-0.1));
            ServerLevel boundLevel = server.getLevel(this.portalDestination.globalVec3().dimension());
            if (boundLevel == null) {
                return;
            }
            PortalEntity destination = new PortalEntity((Level)boundLevel, this.portalDestination.direction(), this.portalDestination.direction().getAxis(), this.portalGunUUID, !this.isPrimaryType, true, this.getOwner().getUUID());
            destination.setPos(this.portalDestination.globalVec3().position());
            destination.refreshDimensions();
            AABB destinationBoundingBox = destination.getBoundingBox();
            List existingPortals2 = boundLevel.getEntitiesOfClass(PortalEntity.class, destinationBoundingBox.inflate(-0.1));
            boolean bl = overlaps = existingPortals.stream().anyMatch(existingPortal -> existingPortal.getBoundingBox().intersects(newBoundingBox) && !existingPortal.getPortalGunUUID().equals(source.getPortalGunUUID())) || existingPortals2.stream().anyMatch(existingPortal2 -> existingPortal2.getBoundingBox().intersects(destinationBoundingBox) && !existingPortal2.getPortalGunUUID().equals(destination.getPortalGunUUID()));
            if (!overlaps) {
                this.closeMyPortals(server);
                level.addFreshEntity((Entity)source);
                boundLevel.addFreshEntity((Entity)destination);
                this.linkPortals(source, destination);
                this.hasSpawnedPortal = true;
            }
            this.discard();
        }
    }

    protected void spawnPortal(double x, double y, double z, Direction direction, BlockPos hitPos) {
        Level level = this.level();
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        if (this.getOwner() == null) {
            return;
        }
        if (!level.isClientSide) {
            PortalEntity portal = new PortalEntity(level, direction, PortalProjectile.getPortalAlignment(this.getDeltaMovement()), this.portalGunUUID, this.isPrimaryType, false, this.getOwner().getUUID());
            if (direction.getAxis() != Direction.Axis.Y) {
                y -= 1.5;
                BlockState belowState = level.getBlockState(hitPos.relative(direction).below());
                if (!belowState.isAir()) {
                    y += 1.0;
                    BlockState aboveState = level.getBlockState(hitPos.relative(direction).above());
                    if (!aboveState.isAir()) {
                        this.discard();
                        return;
                    }
                }
            } else if (PortalProjectile.getPortalAlignment(this.getDeltaMovement()) == Direction.Axis.X) {
                x -= 0.5;
            } else {
                z -= 0.5;
            }
            portal.setPos(x, y, z);
            portal.refreshDimensions();
            AABB newBoundingBox = portal.getBoundingBox();
            List existingPortals = level.getEntitiesOfClass(PortalEntity.class, newBoundingBox.inflate(-0.1));
            boolean overlaps = existingPortals.stream().anyMatch(existingPortal -> existingPortal.getBoundingBox().intersects(newBoundingBox));
            if (!overlaps) {
                this.clearMatchingPortal(server);
                level.addFreshEntity((Entity)portal);
                this.linkPortals(server, portal);
            }
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("portalGunUUID")) {
            this.portalGunUUID = compound.getUUID("portalGunUUID");
        }
        if (compound.contains("portalDestination")) {
            this.portalDestination = NBTHelpers.PortalDestination.fromNBT(compound.getCompound("portalDestination"));
        }
        this.isPrimaryType = compound.getBoolean("isPrimaryType");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("isPrimaryType", this.isPrimaryType);
        if (this.portalGunUUID != null) {
            compound.putUUID("portalGunUUID", this.portalGunUUID);
        }
        if (this.portalDestination != null) {
            compound.put("portalDestination", (Tag)NBTHelpers.PortalDestination.toNBT(this.portalDestination));
        }
    }

    private static Direction.Axis getPortalAlignment(Vec3 velocity) {
        double absZ;
        double absX = Math.abs(velocity.x);
        return absX > (absZ = Math.abs(velocity.z)) ? Direction.Axis.X : Direction.Axis.Z;
    }
}

