/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blocks.BlockBreakerT1;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface RedstoneControlledBE {
    public RedstoneControlData getRedstoneControlData();

    public BlockEntity getBlockEntity();

    default public void setRedstoneSettings(int redstoneMode) {
        BlockState blockState;
        this.getRedstoneControlData().redstoneMode = MiscHelpers.RedstoneMode.values()[redstoneMode];
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            baseMachineBE.markDirtyClient();
        }
        if ((blockState = this.getBlockEntity().getBlockState()).hasProperty((Property)BlockBreakerT1.ACTIVE)) {
            this.getBlockEntity().getLevel().setBlockAndUpdate(this.getBlockEntity().getBlockPos(), (BlockState)blockState.setValue((Property)BlockBreakerT1.ACTIVE, (Comparable)Boolean.valueOf(this.isActiveRedstoneTestOnly())));
        }
    }

    default public void evaluateRedstone() {
        if (!this.getRedstoneControlData().checkedRedstone) {
            boolean newRedstoneSignal = this.getBlockEntity().getLevel().hasNeighborSignal(this.getBlockEntity().getBlockPos());
            if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE) && !this.getRedstoneControlData().receivingRedstone && newRedstoneSignal) {
                this.getRedstoneControlData().pulsed = true;
            }
            this.getRedstoneControlData().receivingRedstone = newRedstoneSignal;
            this.getRedstoneControlData().checkedRedstone = true;
            BlockState blockState = this.getBlockEntity().getBlockState();
            if (blockState.hasProperty((Property)BlockBreakerT1.ACTIVE)) {
                this.getBlockEntity().getLevel().setBlockAndUpdate(this.getBlockEntity().getBlockPos(), (BlockState)blockState.setValue((Property)BlockBreakerT1.ACTIVE, (Comparable)Boolean.valueOf(this.isActiveRedstoneTestOnly())));
            }
        }
    }

    default public boolean isActiveRedstoneTestOnly() {
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.IGNORED)) {
            return true;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.LOW)) {
            return !this.getRedstoneControlData().receivingRedstone;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.HIGH)) {
            return this.getRedstoneControlData().receivingRedstone;
        }
        return this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE) && this.getRedstoneControlData().pulsed;
    }

    default public boolean isActiveRedstone() {
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.IGNORED)) {
            return true;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.LOW)) {
            return !this.getRedstoneControlData().receivingRedstone;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.HIGH)) {
            return this.getRedstoneControlData().receivingRedstone;
        }
        if (this.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE) && this.getRedstoneControlData().pulsed) {
            this.getRedstoneControlData().pulsed = false;
            return true;
        }
        return false;
    }

    default public void saveRedstoneSettings(CompoundTag tag) {
        tag.putInt("redstoneMode", this.getRedstoneControlData().redstoneMode.ordinal());
        tag.putBoolean("pulsed", this.getRedstoneControlData().pulsed);
        tag.putBoolean("receivingRedstone", this.getRedstoneControlData().receivingRedstone);
    }

    default public void loadRedstoneSettings(CompoundTag tag) {
        if (tag.contains("redstoneMode")) {
            this.getRedstoneControlData().redstoneMode = MiscHelpers.RedstoneMode.values()[tag.getInt("redstoneMode")];
            this.getRedstoneControlData().pulsed = tag.getBoolean("pulsed");
            this.getRedstoneControlData().receivingRedstone = tag.getBoolean("receivingRedstone");
        }
    }
}

