/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.entityrenders;

import com.direwolf20.justdirethings.client.renderers.RenderHelpers;
import com.direwolf20.justdirethings.common.entities.TimeWandEntity;
import com.direwolf20.justdirethings.setup.Config;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TimeWandEntityRender
extends EntityRenderer<TimeWandEntity> {
    public TimeWandEntityRender(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(TimeWandEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int pPackedLight) {
        BlockPos blockPos = pEntity.blockPosition();
        if (pEntity.level().getBlockState(blockPos).isAir()) {
            return;
        }
        matrixStackIn.pushPose();
        float tickRateProgress = (float)pEntity.getTickSpeed() / (float)Config.logBase2((Integer)Config.TIME_WAND_MAX_MULTIPLIER.get());
        float timeProgress = (float)pEntity.getRemainingTime() / (float)pEntity.getTotalTime();
        this.renderProgressBarOnSide(matrixStackIn, bufferIn, 0.3f, tickRateProgress, 0.0f, 1.0f, 0.0f, 0.5f, pPackedLight);
        this.renderProgressBarOnSide(matrixStackIn, bufferIn, 0.6f, timeProgress, 1.0f, 0.0f, 0.0f, 0.5f, pPackedLight);
        String timeRate = "x" + pEntity.getAccelerationRate();
        int timeRemaining = pEntity.getRemainingTime();
        float timeInSeconds = (float)timeRemaining / 20.0f;
        String timeRemains = String.format("%.2f", Float.valueOf(timeInSeconds)) + "s";
        float paddingLeftRight = 0.13f;
        this.drawText(matrixStackIn, bufferIn, timeRate, new Vector3f(-paddingLeftRight, 0.39f, 0.51f), Axis.YP.rotationDegrees(0.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRate, new Vector3f(paddingLeftRight, 0.39f, -0.51f), Axis.YP.rotationDegrees(180.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRate, new Vector3f(0.51f, 0.39f, paddingLeftRight), Axis.YP.rotationDegrees(90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRate, new Vector3f(-0.51f, 0.39f, -paddingLeftRight), Axis.YP.rotationDegrees(-90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRate, new Vector3f(-paddingLeftRight, 1.01f, 0.110000014f), Axis.XP.rotationDegrees(90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRate, new Vector3f(-paddingLeftRight, -0.01f, -0.110000014f), Axis.XP.rotationDegrees(-90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRemains, new Vector3f(-paddingLeftRight, 0.69f, 0.51f), Axis.YP.rotationDegrees(0.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRemains, new Vector3f(paddingLeftRight, 0.69f, -0.51f), Axis.YP.rotationDegrees(180.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRemains, new Vector3f(0.51f, 0.69f, paddingLeftRight), Axis.YP.rotationDegrees(90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRemains, new Vector3f(-0.51f, 0.69f, -paddingLeftRight), Axis.YP.rotationDegrees(-90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRemains, new Vector3f(-paddingLeftRight, 1.01f, -0.19f), Axis.XP.rotationDegrees(90.0f), ChatFormatting.WHITE.getColor());
        this.drawText(matrixStackIn, bufferIn, timeRemains, new Vector3f(-paddingLeftRight, -0.01f, 0.19f), Axis.XP.rotationDegrees(-90.0f), ChatFormatting.WHITE.getColor());
        matrixStackIn.popPose();
    }

    private void renderProgressBarOnSide(PoseStack matrixStack, MultiBufferSource buffer, float yStart, float progress, float r, float g, float b, float a, int pPackedLight) {
        float barWidth = 0.8f;
        float barHeight = 0.1f;
        float barProgress = barWidth * progress;
        this.renderBarFace(matrixStack, buffer, -0.4f, yStart, 0.5f, barProgress, barHeight, r, g, b, a, pPackedLight, new Quaternionf().rotateY(0.0f));
        this.renderBarFace(matrixStack, buffer, -0.4f, yStart, 0.5f, barProgress, barHeight, r, g, b, a, pPackedLight, new Quaternionf().rotateY((float)Math.PI));
        this.renderBarFace(matrixStack, buffer, -0.4f, yStart, 0.5f, barProgress, barHeight, r, g, b, a, pPackedLight, new Quaternionf().rotateY(1.5707964f));
        this.renderBarFace(matrixStack, buffer, -0.4f, yStart, 0.5f, barProgress, barHeight, r, g, b, a, pPackedLight, new Quaternionf().rotateY(-1.5707964f));
        this.renderBarFace(matrixStack, buffer, -0.4f, yStart - 0.5f, 1.0f, barProgress, barHeight, r, g, b, a, pPackedLight, new Quaternionf().rotateX(-1.5707964f));
        this.renderBarFace(matrixStack, buffer, -0.4f, yStart - 0.5f, 0.0f, barProgress, barHeight, r, g, b, a, pPackedLight, new Quaternionf().rotateX(1.5707964f));
    }

    private void renderBarFace(PoseStack matrixStack, MultiBufferSource buffer, float xStart, float yStart, float zStart, float barWidth, float barHeight, float r, float g, float b, float a, int pPackedLight, Quaternionf rotation) {
        matrixStack.pushPose();
        matrixStack.mulPose(rotation);
        RenderHelpers.renderBoxSolid(matrixStack, matrixStack.last().pose(), buffer, new AABB((double)xStart, (double)yStart, (double)zStart, (double)(xStart + barWidth), (double)(yStart + barHeight), (double)zStart), r, g, b, a);
        matrixStack.popPose();
    }

    public ResourceLocation getTextureLocation(TimeWandEntity pEntity) {
        return null;
    }

    private void drawText(PoseStack matrixStack, MultiBufferSource source, String text, Vector3f translateVector, Quaternionf rotate, int color) {
        matrixStack.pushPose();
        matrixStack.translate(translateVector.x(), translateVector.y(), translateVector.z());
        matrixStack.scale(0.01f, -0.01f, 0.01f);
        matrixStack.mulPose(rotate);
        this.getFont().drawInBatch(text, 0.0f, 0.0f, -1, false, matrixStack.last().pose(), source, Font.DisplayMode.NORMAL, 0, color);
        matrixStack.popPose();
    }
}

