/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class ThirdPersonRendererMixin<T extends LivingEntity>
extends AgeableListModel<T> {
    @Unique
    private boolean moonlight$isTwoHanded = false;

    @Inject(method={"poseRightArm(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void poseRightArm(T entity, CallbackInfo ci) {
        HumanoidArm handSide;
        ItemStack stack;
        IThirdPersonAnimationProvider provider;
        if (this.moonlight$isTwoHanded) {
            ci.cancel();
        }
        if ((provider = IThirdPersonAnimationProvider.get((stack = entity.getItemInHand((handSide = entity.getMainArm()) == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND)).getItem())) != null && provider.poseRightArm(stack, (HumanoidModel)this, entity, handSide)) {
            if (provider.isTwoHanded()) {
                this.moonlight$isTwoHanded = true;
            }
            ci.cancel();
        }
    }

    @Inject(method={"poseLeftArm(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void poseLeftArm(T entity, CallbackInfo ci) {
        HumanoidArm handSide;
        ItemStack stack;
        IThirdPersonAnimationProvider provider;
        if (this.moonlight$isTwoHanded) {
            ci.cancel();
        }
        if ((provider = IThirdPersonAnimationProvider.get((stack = entity.getItemInHand((handSide = entity.getMainArm()) == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)).getItem())) != null && provider.poseLeftArm(stack, (HumanoidModel)this, entity, handSide)) {
            if (provider.isTwoHanded()) {
                this.moonlight$isTwoHanded = true;
            }
            ci.cancel();
        }
    }

    @Inject(method={"setupAnim*(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="RETURN")}, require=0)
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.moonlight$isTwoHanded = false;
    }
}

