/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.map;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.neoforge.MapDataInternalImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MapDataInternal {
    public static final MapRegistry<CustomMapData.Type<?, ?>> CUSTOM_MAP_DATA_TYPES = new MapRegistry("custom_map_data_types");
    public static final ResourceKey<Registry<MLMapDecorationType<?, ?>>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Moonlight.res("map_marker"));
    public static final ResourceLocation GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final MapRegistry<Supplier<MLSpecialMapDecorationType<?, ?>>> CODE_TYPES_FACTORIES = new MapRegistry("code_map_decoration_types_factories");
    private static final List<TriFunction<Player, MapId, MapItemSavedData, Set<MLMapMarker<?>>>> DYNAMIC_SERVER = Collections.synchronizedList(new ArrayList());
    private static final List<BiFunction<MapId, MapItemSavedData, Set<MLMapMarker<?>>>> DYNAMIC_CLIENT = Collections.synchronizedList(new ArrayList());

    public static <P, T extends CustomMapData<?, P>> CustomMapData.Type<P, T> registerCustomMapSavedData(CustomMapData.Type<P, T> type) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(type.id())) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + String.valueOf(type.id()));
        }
        CUSTOM_MAP_DATA_TYPES.register(type.id(), type);
        return type;
    }

    @Deprecated(forRemoval=true)
    public static MLMapDecorationType<?, ?> getGenericStructure() {
        return MapDataInternal.getOrDefault(GENERIC_STRUCTURE_ID);
    }

    public static void registerCustomType(ResourceLocation id, Supplier<MLSpecialMapDecorationType<?, ?>> decorationType) {
        CODE_TYPES_FACTORIES.register(id, decorationType);
    }

    public static MLSpecialMapDecorationType<?, ?> createCustomType(ResourceLocation factoryID) {
        Supplier<MLSpecialMapDecorationType<?, ?>> factory = Objects.requireNonNull(CODE_TYPES_FACTORIES.getValue(factoryID), "No map decoration type with id: " + String.valueOf(factoryID));
        MLSpecialMapDecorationType<?, ?> specialType = factory.get();
        specialType.factoryID = factoryID;
        return specialType;
    }

    public static MLMapDecorationType<?, ?> getAssociatedType(Holder<Structure> structure) {
        for (MLMapDecorationType<?, ?> v : MapDataInternal.getValues()) {
            Optional<HolderSet<Structure>> associatedStructure = v.getAssociatedStructure();
            if (!associatedStructure.isPresent() || !associatedStructure.get().contains(structure)) continue;
            return v;
        }
        return MapDataInternal.getGenericStructure();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDataInternalImpl.init();
    }

    @Deprecated(forRemoval=true)
    public static Registry<MLMapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().registryOrThrow(KEY);
    }

    public static Registry<MLMapDecorationType<?, ?>> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(KEY);
    }

    @Deprecated(forRemoval=true)
    public static Collection<MLMapDecorationType<?, ?>> getValues() {
        return MapDataInternal.hackyGetRegistry().stream().toList();
    }

    @Deprecated(forRemoval=true)
    public static Set<Map.Entry<ResourceKey<MLMapDecorationType<?, ?>>, MLMapDecorationType<?, ?>>> getEntries() {
        return MapDataInternal.hackyGetRegistry().entrySet();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static MLMapDecorationType<? extends MLMapDecoration, ?> getOrDefault(String id) {
        return MapDataInternal.getOrDefault(ResourceLocation.parse((String)id));
    }

    @Deprecated(forRemoval=true)
    public static MLMapDecorationType<?, ?> getOrDefault(ResourceLocation id) {
        Registry<MLMapDecorationType<?, ?>> reg = MapDataInternal.hackyGetRegistry();
        MLMapDecorationType r = (MLMapDecorationType)reg.get(id);
        if (r == null) {
            return (MLMapDecorationType)reg.get(GENERIC_STRUCTURE_ID);
        }
        return r;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static Holder<MLMapDecorationType<?, ?>> getHolder(ResourceLocation id) {
        return MapDataInternal.hackyGetRegistry().getHolder(id).orElse(null);
    }

    @Deprecated(forRemoval=true)
    public static Optional<MLMapDecorationType<?, ?>> getOptional(ResourceLocation id) {
        return MapDataInternal.hackyGetRegistry().getOptional(id);
    }

    public static Set<MLMapMarker<?>> getDynamicServer(Player player, MapId mapId, MapItemSavedData data) {
        HashSet dynamic = new HashSet();
        for (TriFunction<Player, MapId, MapItemSavedData, Set<MLMapMarker<?>>> v : DYNAMIC_SERVER) {
            dynamic.addAll((Collection)v.apply(player, mapId, data));
        }
        return dynamic;
    }

    public static Set<MLMapMarker<?>> getDynamicClient(MapId mapId, MapItemSavedData data) {
        HashSet dynamic = new HashSet();
        for (BiFunction<MapId, MapItemSavedData, Set<MLMapMarker<?>>> v : DYNAMIC_CLIENT) {
            dynamic.addAll((Collection)v.apply(mapId, data));
        }
        return dynamic;
    }

    public static List<MLMapMarker<?>> getMarkersFromWorld(BlockGetter reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (MLMapDecorationType<?, ?> type : MapDataInternal.getValues()) {
            Object c = type.createMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MLMapMarker<?>)c);
        }
        return list;
    }

    public static void addDynamicClientMarkersEvent(BiFunction<MapId, MapItemSavedData, Set<MLMapMarker<?>>> event) {
        DYNAMIC_CLIENT.add(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<Player, MapId, MapItemSavedData, Set<MLMapMarker<?>>> event) {
        DYNAMIC_SERVER.add(event);
    }
}

