/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.neoforge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.concurrent.ConcurrentCommentedConfig;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.configs.neoforge.ConfigBuilderImpl;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ForgeConfigHolder
extends ModConfigHolder {
    private static final Map<ModConfig, ForgeConfigHolder> BY_FORGE_CONFIG = new HashMap<ModConfig, ForgeConfigHolder>();
    private static final Method LOAD_CONFIG = ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"loadConfig", (Class[])new Class[]{ModConfig.class, Path.class, Function.class});
    private final ModConfigSpec spec;
    private final ModConfig modConfig;
    private final Map<ModConfigSpec.ConfigValue<?>, Object> requireRestartValues;
    private final List<ConfigBuilderImpl.ValueWrapper<?, ?>> specialValues;

    public static ForgeConfigHolder getFromForgeConfig(ModConfig config) {
        return BY_FORGE_CONFIG.get(config);
    }

    ForgeConfigHolder(ResourceLocation name, ModConfigSpec spec, ConfigType type, @Nullable Runnable onChange, List<ModConfigSpec.ConfigValue<?>> requireRestart, List<ConfigBuilderImpl.ValueWrapper<?, ?>> specialValues) {
        super(name, "toml", FMLPaths.CONFIGDIR.get(), type, onChange);
        this.spec = spec;
        this.specialValues = specialValues;
        ModConfig.Type forgeType = this.getConfigType() == ConfigType.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.COMMON;
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        this.modConfig = ConfigTracker.INSTANCE.registerConfig(forgeType, (IConfigSpec)spec, modContainer, this.getFileName());
        IEventBus bus = modContainer.getEventBus();
        if (onChange != null || this.isSynced() || !specialValues.isEmpty()) {
            bus.addListener(this::onConfigChange);
        }
        if (this.isSynced()) {
            NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
        }
        if (!requireRestart.isEmpty()) {
            this.forceLoad();
        }
        this.requireRestartValues = requireRestart.stream().collect(Collectors.toMap(e -> e, ModConfigSpec.ConfigValue::get));
        BY_FORGE_CONFIG.put(this.modConfig, this);
    }

    @Override
    public Path getFullPath() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getFileName());
    }

    @Override
    public void forceLoad() {
        if (this.isLoaded()) {
            return;
        }
        try {
            LOAD_CONFIG.invoke((Object)ConfigTracker.INSTANCE, this.modConfig, this.getFullPath(), ModConfigEvent.Loading::new);
        }
        catch (Exception e) {
            throw new ModConfigHolder.ConfigLoadingException(this, e);
        }
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Nullable
    public ModConfig getModConfig() {
        return this.modConfig;
    }

    @Override
    public boolean isLoaded() {
        return this.spec.isLoaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent, @Nullable ResourceLocation background) {
        return ModList.get().getModContainerById(this.getModId()).flatMap(container -> container.getCustomExtension(IConfigScreenFactory.class).map(factory -> factory.createScreen(container, parent))).orElse(null);
    }

    @Override
    public boolean hasConfigScreen() {
        return ModList.get().getModContainerById(this.getModId()).map(container -> container.getCustomExtension(IConfigScreenFactory.class).isPresent()).orElse(false);
    }

    @ApiStatus.Internal
    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.syncConfigsToPlayer(serverPlayer);
        }
    }

    @ApiStatus.Internal
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().level().isClientSide) {
            this.onRefresh();
        }
    }

    @ApiStatus.Internal
    public void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.getSpec()) {
            if (this.isSynced() && PlatHelper.getPhysicalSide().isServer()) {
                this.sendSyncedConfigsToAllPlayers();
            }
            this.onRefresh();
            this.specialValues.forEach(ConfigBuilderImpl.ValueWrapper::clearCache);
        }
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        try {
            byte[] b = stream.readAllBytes();
            ForgeConfigHolder.acceptConfig(this.modConfig, b);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to sync config file {}:", (Object)this.getFileName(), (Object)e);
        }
    }

    public static void acceptConfig(ModConfig modConfig, byte[] bytes) {
        CommentedConfig commentedConfig = modConfig.getLoadedConfig().config();
        if (commentedConfig instanceof ConcurrentCommentedConfig) {
            ConcurrentCommentedConfig cc = (ConcurrentCommentedConfig)commentedConfig;
            cc.bulkCommentedUpdate(view -> TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(bytes), (Config)view, ParsingMode.REPLACE));
        }
    }

    public boolean requiresGameRestart(ModConfigSpec.ConfigValue<?> value) {
        Object v = this.requireRestartValues.get(value);
        if (v == null) {
            return false;
        }
        return v != value.get();
    }
}

