/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.phys.Vec3;

public class MM_Ghastly
extends MobModifier {
    private static final long coolDown = 6000L;
    private static final float MIN_DISTANCE = 3.0f;
    private static String[] suffix = new String[]{"OMFGFIREBALLS", "theBomber", "ofBallsofFire"};
    private static String[] prefix = new String[]{"bombing", "fireballsy"};
    private long nextAbilityUse = 0L;

    public MM_Ghastly() {
    }

    public MM_Ghastly(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Ghastly";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        long time;
        if (this.hasSteadyTarget() && (time = System.currentTimeMillis()) > this.nextAbilityUse) {
            this.nextAbilityUse = time + 6000L;
            this.tryAbility(mob, (LivingEntity)mob.level().getNearestPlayer((Entity)mob, 12.0));
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || !this.canMobSeeTarget(mob, target)) {
            return;
        }
        if (mob.distanceTo((Entity)target) > 3.0f) {
            double diffX = target.getX() - mob.getX();
            double diffY = target.getBoundingBox().minY + (double)(target.getBbHeight() / 2.0f) - (mob.getY() + (double)(mob.getBbHeight() / 2.0f));
            double diffZ = target.getZ() - mob.getZ();
            mob.setYRot(-((float)Math.atan2(diffX, diffZ)) * 180.0f / (float)Math.PI);
            mob.setYBodyRot(mob.getYRot());
            mob.level().levelEvent(null, 1008, new BlockPos((int)mob.getX(), (int)mob.getY(), (int)mob.getZ()), 0);
            LargeFireball entFB = new LargeFireball(mob.level(), mob, new Vec3(diffX, diffY, diffZ), 1);
            double spawnOffset = 2.0;
            Vec3 mobLook = mob.getViewVector(1.0f);
            double newX = mob.getX() + mobLook.x * spawnOffset;
            double newY = mob.getY() + (double)(mob.getBbHeight() / 2.0f) + 0.5;
            double newZ = mob.getZ() + mobLook.z * spawnOffset;
            mob.setPos(newX, newY, newZ);
            mob.level().addFreshEntity((Entity)entFB);
        }
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

