/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;

public class MM_Cloaking
extends MobModifier {
    private static final long coolDown = 10000L;
    private static Class<?>[] disallowed = new Class[]{Spider.class};
    private static String[] suffix = new String[]{"ofStalking", "theUnseen", "thePredator"};
    private static String[] prefix = new String[]{"stalking", "unseen", "hunting"};
    private long nextAbilityUse = 0L;

    public MM_Cloaking() {
    }

    public MM_Cloaking(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Cloaking";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        if (this.hasSteadyTarget() && this.getMobTarget() instanceof Player) {
            this.tryAbility(mob);
        }
        return super.onUpdate(mob);
    }

    @Override
    public float onHurt(LivingEntity mob, DamageSource source, float damage) {
        if (source.getDirectEntity() != null && source.getDirectEntity() instanceof LivingEntity) {
            this.tryAbility(mob);
        }
        return super.onHurt(mob, source, damage);
    }

    private void tryAbility(LivingEntity mob) {
        long time = System.currentTimeMillis();
        if (time > this.nextAbilityUse) {
            this.nextAbilityUse = time + 10000L;
            mob.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 200));
        }
    }

    @Override
    public Class<?>[] getBlackListMobClasses() {
        return disallowed;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

