/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.EntityEventHandler;
import atomicstryker.infernalmobs.common.GsonConfig;
import atomicstryker.infernalmobs.common.InfernalCommandFindEntityClass;
import atomicstryker.infernalmobs.common.InfernalCommandSpawnInfernal;
import atomicstryker.infernalmobs.common.InfernalMobsConfig;
import atomicstryker.infernalmobs.common.ItemConfigHelper;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SaveEventHandler;
import atomicstryker.infernalmobs.common.SidedCache;
import atomicstryker.infernalmobs.common.mods.MM_1UP;
import atomicstryker.infernalmobs.common.mods.MM_Alchemist;
import atomicstryker.infernalmobs.common.mods.MM_Berserk;
import atomicstryker.infernalmobs.common.mods.MM_Blastoff;
import atomicstryker.infernalmobs.common.mods.MM_Bulwark;
import atomicstryker.infernalmobs.common.mods.MM_Choke;
import atomicstryker.infernalmobs.common.mods.MM_Cloaking;
import atomicstryker.infernalmobs.common.mods.MM_Darkness;
import atomicstryker.infernalmobs.common.mods.MM_Ender;
import atomicstryker.infernalmobs.common.mods.MM_Exhaust;
import atomicstryker.infernalmobs.common.mods.MM_Fiery;
import atomicstryker.infernalmobs.common.mods.MM_Ghastly;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.mods.MM_Lifesteal;
import atomicstryker.infernalmobs.common.mods.MM_Ninja;
import atomicstryker.infernalmobs.common.mods.MM_Poisonous;
import atomicstryker.infernalmobs.common.mods.MM_Quicksand;
import atomicstryker.infernalmobs.common.mods.MM_Regen;
import atomicstryker.infernalmobs.common.mods.MM_Rust;
import atomicstryker.infernalmobs.common.mods.MM_Sapper;
import atomicstryker.infernalmobs.common.mods.MM_Sprint;
import atomicstryker.infernalmobs.common.mods.MM_Sticky;
import atomicstryker.infernalmobs.common.mods.MM_Storm;
import atomicstryker.infernalmobs.common.mods.MM_Unyielding;
import atomicstryker.infernalmobs.common.mods.MM_Vengeance;
import atomicstryker.infernalmobs.common.mods.MM_Weakness;
import atomicstryker.infernalmobs.common.mods.MM_Webber;
import atomicstryker.infernalmobs.common.mods.MM_Wither;
import atomicstryker.infernalmobs.common.network.AirPacket;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.KnockBackPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import atomicstryker.infernalmobs.common.network.VelocityPacket;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="infernalmobs")
public class InfernalMobsCore {
    public static final String MOD_ID = "infernalmobs";
    public static Logger LOGGER;
    private static InfernalMobsCore instance;
    private final long existCheckDelay = 5000L;
    protected File configFile;
    protected InfernalMobsConfig config;
    private long nextExistCheckTime;
    private ItemConfigHelper lootItemDropsElite;
    private ItemConfigHelper lootItemDropsUltra;
    private ItemConfigHelper lootItemDropsInfernal;
    private HashMap<String, Boolean> classesAllowedMap;
    private HashMap<String, Boolean> classesForcedMap;
    private HashMap<String, Double> classesHealthMap;
    private Entity infCheckA;
    private Entity infCheckB;
    private ArrayList<Class<? extends MobModifier>> mobMods = null;
    private ArrayList<Enchantment> enchantmentList;
    private HashMap<String, Long> modifiedPlayerTimes;

    public InfernalMobsCore(IEventBus modEventBus) {
        instance = this;
        this.nextExistCheckTime = System.currentTimeMillis();
        this.classesAllowedMap = new HashMap();
        this.classesForcedMap = new HashMap();
        this.classesHealthMap = new HashMap();
        this.modifiedPlayerTimes = new HashMap();
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new EntityEventHandler());
        NeoForge.EVENT_BUS.register((Object)new SaveEventHandler());
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)new InfernalMobsClient());
        }
        LOGGER = LogManager.getLogger();
        modEventBus.addListener(this::registerNetworking);
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID).optional();
        registrar.playBidirectional(HealthPacket.TYPE, HealthPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler((payload, context) -> InfernalMobsCore.instance().onHealthPacketForClient((HealthPacket)payload, context), (payload, context) -> InfernalMobsCore.instance().onHealthPacket((HealthPacket)payload, context)));
        registrar.playBidirectional(MobModsPacket.TYPE, MobModsPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler((payload, context) -> InfernalMobsCore.instance().onMobModsPacketForClient((MobModsPacket)payload, context), (payload, context) -> InfernalMobsCore.instance().onMobModsPacket((MobModsPacket)payload, context)));
        registrar.playToClient(AirPacket.TYPE, AirPacket.STREAM_CODEC, InfernalMobsCore.instance()::onAirPacketForClient);
        registrar.playToClient(VelocityPacket.TYPE, VelocityPacket.STREAM_CODEC, InfernalMobsCore.instance()::onVelocityPacketForClient);
        registrar.playToClient(KnockBackPacket.TYPE, KnockBackPacket.STREAM_CODEC, InfernalMobsCore.instance()::onKnockBackPacketForClient);
    }

    private void onHealthPacketForClient(HealthPacket healthPacket, IPayloadContext playPayloadContext) {
        if (FMLEnvironment.dist.isClient()) {
            InfernalMobsClient.instance().onHealthPacketForClient(healthPacket, playPayloadContext);
        }
    }

    private void onKnockBackPacketForClient(KnockBackPacket knockBackPacket, IPayloadContext playPayloadContext) {
        if (FMLEnvironment.dist.isClient()) {
            InfernalMobsClient.instance().onKnockBackPacket(knockBackPacket, playPayloadContext);
        }
    }

    private void onMobModsPacketForClient(MobModsPacket mobModsPacket, IPayloadContext playPayloadContext) {
        if (FMLEnvironment.dist.isClient()) {
            InfernalMobsClient.instance().onMobModsPacketToClient(mobModsPacket, playPayloadContext);
        }
    }

    private void onAirPacketForClient(AirPacket airPacket, IPayloadContext playPayloadContext) {
        if (FMLEnvironment.dist.isClient()) {
            InfernalMobsClient.instance().onAirPacket(airPacket, playPayloadContext);
        }
    }

    private void onVelocityPacketForClient(VelocityPacket velocityPacket, IPayloadContext playPayloadContext) {
        if (FMLEnvironment.dist.isClient()) {
            InfernalMobsClient.instance().onVelocityPacket(velocityPacket, playPayloadContext);
        }
    }

    private void onMobModsPacket(MobModsPacket mobModsPacket, IPayloadContext playPayloadContext) {
        Entity ent;
        ServerPlayer p = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(mobModsPacket.stringData());
        LOGGER.trace("player {} from string {} querying server for mods of entity id {}", (Object)p, (Object)mobModsPacket.stringData(), (Object)mobModsPacket.entID());
        if (p != null && (ent = p.level().getEntity(mobModsPacket.entID())) instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)ent;
            MobModifier mod = InfernalMobsCore.getMobModifiers(e);
            LOGGER.trace("resolves to entity {} modifiers {}", (Object)ent, (Object)mod);
            if (mod != null) {
                LOGGER.trace("server sending mods {} for ent-ID {}", (Object)mod.getLinkedModNameUntranslated(), (Object)mobModsPacket.entID());
                MobModsPacket response = new MobModsPacket(mod.getLinkedModNameUntranslated(), mobModsPacket.entID(), 1);
                PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)response, (CustomPacketPayload[])new CustomPacketPayload[0]);
                InfernalMobsCore.instance().sendHealthPacket(e);
            }
        }
    }

    private void onHealthPacket(HealthPacket healthPacket, IPayloadContext playPayloadContext) {
        LivingEntity e;
        MobModifier mod;
        Entity ent;
        ServerPlayer p = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(healthPacket.stringData());
        if (p != null && (ent = p.level().getEntity(healthPacket.entID())) instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers(e = (LivingEntity)ent)) != null) {
            HealthPacket response = new HealthPacket(healthPacket.stringData(), healthPacket.entID(), e.getHealth(), e.getMaxHealth());
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)response, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static InfernalMobsCore instance() {
        return instance;
    }

    public static MobModifier getMobModifiers(LivingEntity ent) {
        return SidedCache.getInfernalMobs(ent.level()).get(ent);
    }

    public static boolean getIsRareEntityOnline(LivingEntity ent) {
        return SidedCache.getInfernalMobs(ent.level()).containsKey(ent);
    }

    public static boolean isBlockedBeingInfernal(LivingEntity ent) {
        boolean result;
        CompoundTag persistentData = ent.getPersistentData();
        String storedInfernalTag = persistentData.getString(InfernalMobsCore.instance().getNBTTag());
        boolean bl = result = !storedInfernalTag.isEmpty() && InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities().equals(storedInfernalTag);
        if (result) {
            LOGGER.debug("entity {} was spawned in unmodified before, not modifying it", (Object)ent);
            return true;
        }
        for (String bannedTag : InfernalMobsCore.instance().config.getEntityTagBlackList()) {
            if (!persistentData.contains(bannedTag)) continue;
            return true;
        }
        return false;
    }

    public static void setMobWasSpawnedBefore(LivingEntity ent) {
        ent.getPersistentData().putString(InfernalMobsCore.instance().getNBTTag(), InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities());
    }

    public static void clearAllElitesOfLevel(net.minecraft.world.level.Level level) {
        SidedCache.getInfernalMobs(level).clear();
    }

    public static void removeEntFromElites(LivingEntity entity) {
        SidedCache.getInfernalMobs(entity.level()).remove(entity);
    }

    public String getNBTTag() {
        return "InfernalMobsMod";
    }

    public String getNBTMarkerForNonInfernalEntities() {
        return "notInfernal";
    }

    @SubscribeEvent
    public void commonSetup(ServerStartedEvent evt) {
        this.initIfNeeded((net.minecraft.world.level.Level)evt.getServer().getAllLevels().iterator().next());
    }

    public void initIfNeeded(net.minecraft.world.level.Level world) {
        if (this.mobMods == null) {
            Path mcFolder;
            this.prepareModList();
            if (world.isClientSide()) {
                mcFolder = InfernalMobsClient.getMcFolder().toPath();
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                mcFolder = server.getServerDirectory();
            }
            this.configFile = mcFolder.resolve("config" + File.separatorChar + "infernalmobs.cfg").toFile();
            this.loadConfig(world);
            LOGGER.info("InfernalMobsCore commonSetup completed! Modifiers ready: " + this.mobMods.size());
            LOGGER.info("InfernalMobsCore commonSetup completed! config file at: " + this.configFile.getAbsolutePath());
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        evt.getDispatcher().register(InfernalCommandFindEntityClass.BUILDER);
        evt.getDispatcher().register(InfernalCommandSpawnInfernal.BUILDER);
    }

    private void prepareModList() {
        this.mobMods = new ArrayList();
        this.mobMods.add(MM_1UP.class);
        this.mobMods.add(MM_Alchemist.class);
        this.mobMods.add(MM_Berserk.class);
        this.mobMods.add(MM_Blastoff.class);
        this.mobMods.add(MM_Bulwark.class);
        this.mobMods.add(MM_Choke.class);
        this.mobMods.add(MM_Cloaking.class);
        this.mobMods.add(MM_Darkness.class);
        this.mobMods.add(MM_Ender.class);
        this.mobMods.add(MM_Exhaust.class);
        this.mobMods.add(MM_Fiery.class);
        this.mobMods.add(MM_Ghastly.class);
        this.mobMods.add(MM_Gravity.class);
        this.mobMods.add(MM_Lifesteal.class);
        this.mobMods.add(MM_Ninja.class);
        this.mobMods.add(MM_Poisonous.class);
        this.mobMods.add(MM_Quicksand.class);
        this.mobMods.add(MM_Regen.class);
        this.mobMods.add(MM_Rust.class);
        this.mobMods.add(MM_Sapper.class);
        this.mobMods.add(MM_Sprint.class);
        this.mobMods.add(MM_Sticky.class);
        this.mobMods.add(MM_Storm.class);
        this.mobMods.add(MM_Unyielding.class);
        this.mobMods.add(MM_Vengeance.class);
        this.mobMods.add(MM_Weakness.class);
        this.mobMods.add(MM_Webber.class);
        this.mobMods.add(MM_Wither.class);
    }

    private void loadConfig(net.minecraft.world.level.Level world) {
        InfernalMobsConfig defaultConfig = new InfernalMobsConfig();
        defaultConfig.setEliteRarity(15);
        defaultConfig.setUltraRarity(7);
        defaultConfig.setInfernoRarity(7);
        defaultConfig.setUseSimpleEntityClassNames(true);
        defaultConfig.setDisableHealthBar(false);
        defaultConfig.setModHealthFactor(1.0);
        ArrayList<String> dropsElite = new ArrayList<String>();
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_SHOVEL), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_PICKAXE), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_AXE), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_SWORD), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_HOE), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_HELMET), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_BOOTS), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_CHESTPLATE), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_LEGGINGS), world.registryAccess()));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.COOKIE, 5), world.registryAccess()));
        defaultConfig.setDroppedItemIDsElite(dropsElite);
        ArrayList<String> dropsUltra = new ArrayList<String>();
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_HOE), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.BOW), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_HELMET), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_BOOTS), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_CHESTPLATE), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.IRON_LEGGINGS), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.GOLDEN_HELMET), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.GOLDEN_BOOTS), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.GOLDEN_APPLE, 3), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.BLAZE_POWDER, 5), world.registryAccess()));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.ENCHANTED_BOOK), world.registryAccess()));
        defaultConfig.setDroppedItemIDsUltra(dropsUltra);
        ArrayList<String> dropsInfernal = new ArrayList<String>();
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.ENCHANTED_BOOK), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND, 3), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_SWORD), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_AXE), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_HOE), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_HELMET), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_BOOTS), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), world.registryAccess()));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Items.ENDER_PEARL, 3), world.registryAccess()));
        defaultConfig.setDroppedItemIDsInfernal(dropsInfernal);
        defaultConfig.setMaxDamage(10.0);
        defaultConfig.setDimensionIDBlackList(new ArrayList<String>());
        HashMap<String, Boolean> modsEnabledMap = new HashMap<String, Boolean>();
        for (Class<? extends MobModifier> c2 : this.mobMods) {
            modsEnabledMap.put(c2.getSimpleName(), true);
        }
        defaultConfig.setModsEnabled(modsEnabledMap);
        ArrayList<String> entityTagBlackList = new ArrayList<String>();
        entityTagBlackList.add("affixes");
        defaultConfig.setEntityTagBlackList(entityTagBlackList);
        this.config = GsonConfig.loadConfigWithDefault(InfernalMobsConfig.class, this.configFile, defaultConfig);
        this.lootItemDropsElite = new ItemConfigHelper(this.config.getDroppedItemIDsElite(), LOGGER, world.registryAccess());
        this.lootItemDropsUltra = new ItemConfigHelper(this.config.getDroppedItemIDsUltra(), LOGGER, world.registryAccess());
        this.lootItemDropsInfernal = new ItemConfigHelper(this.config.getDroppedItemIDsInfernal(), LOGGER, world.registryAccess());
        this.mobMods.removeIf(c -> !this.config.getModsEnabled().containsKey(c.getSimpleName()) || this.config.getModsEnabled().get(c.getSimpleName()) == false);
    }

    public void processEntitySpawn(LivingEntity entity) {
        if (!(entity.level().isClientSide || this.config == null || InfernalMobsCore.getIsRareEntityOnline(entity) || InfernalMobsCore.isBlockedBeingInfernal(entity))) {
            if (this.isClassAllowed(entity) && (instance.checkEntityClassForced(entity) || entity.level().random.nextInt(this.config.getEliteRarity()) == 0)) {
                try {
                    MobModifier mod;
                    ResourceKey worldRegistryKey = entity.getCommandSenderWorld().dimension();
                    ResourceLocation worldResourceLocation = worldRegistryKey.location();
                    if (!this.config.getDimensionIDBlackList().contains(worldResourceLocation.toString()) && (mod = instance.createMobModifiers(entity)) != null) {
                        SidedCache.getInfernalMobs(entity.level()).put(entity, mod);
                        mod.onSpawningCompleteStoreModsAndBuffHealth(entity);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.ERROR, "processEntitySpawn() threw an exception");
                    e.printStackTrace();
                }
            } else {
                InfernalMobsCore.setMobWasSpawnedBefore(entity);
            }
        }
    }

    private boolean isClassAllowed(LivingEntity entity) {
        if (entity instanceof TamableAnimal) {
            return false;
        }
        return instance.checkEntityClassAllowed(entity);
    }

    private String getEntityNameSafe(Entity entity) {
        String result;
        try {
            result = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getPath();
        }
        catch (Exception e) {
            result = entity.getClass().getSimpleName();
            System.err.println("Entity of class " + result + " crashed when EntityList.getEntityString was queried, for shame! Using classname instead.");
            System.err.println("If this message is spamming too much for your taste set useSimpleEntityClassnames true in your Infernal Mobs config");
        }
        return result;
    }

    private boolean checkEntityClassAllowed(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesAllowedMap.containsKey(entName)) {
            return this.classesAllowedMap.get(entName);
        }
        boolean result = true;
        if (!this.config.getPermittedentities().containsKey(entName)) {
            this.config.getPermittedentities().put(entName, true);
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getPermittedentities().get(entName);
            this.classesAllowedMap.put(entName, result);
        }
        return result;
    }

    private boolean checkEntityClassForced(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesForcedMap.containsKey(entName)) {
            return this.classesForcedMap.get(entName);
        }
        boolean result = false;
        if (!this.config.getEntitiesalwaysinfernal().containsKey(entName)) {
            this.config.getEntitiesalwaysinfernal().put(entName, false);
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getEntitiesalwaysinfernal().get(entName);
            this.classesForcedMap.put(entName, result);
        }
        return result;
    }

    public double getMobClassMaxHealth(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesHealthMap.containsKey(entName)) {
            return this.classesHealthMap.get(entName);
        }
        double result = entity.getMaxHealth();
        if (!this.config.getEntitybasehealth().containsKey(entName)) {
            this.config.getEntitybasehealth().put(entName, Double.valueOf(entity.getMaxHealth()));
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getEntitybasehealth().get(entName);
            this.classesHealthMap.put(entName, result);
        }
        return result;
    }

    public void setEntityHealthPastMax(LivingEntity entity, float amount) {
        entity.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)amount);
        entity.setHealth(amount);
        instance.sendHealthPacket(entity);
    }

    private MobModifier createMobModifiers(LivingEntity entity) {
        int number = 2 + entity.level().random.nextInt(3);
        ArrayList possibleMods = Lists.newArrayList(this.mobMods);
        if (entity.level().random.nextInt(this.config.getUltraRarity()) == 0) {
            number += 3 + entity.level().random.nextInt(2);
            if (entity.level().random.nextInt(this.config.getInfernoRarity()) == 0) {
                number += 3 + entity.level().random.nextInt(2);
            }
        }
        MobModifier lastMod = null;
        while (number > 0 && !possibleMods.isEmpty()) {
            int index = entity.level().random.nextInt(possibleMods.size());
            MobModifier nextMod = null;
            try {
                nextMod = lastMod == null ? (MobModifier)((Class)possibleMods.get(index)).getConstructor(new Class[0]).newInstance(new Object[0]) : (MobModifier)((Class)possibleMods.get(index)).getConstructor(MobModifier.class).newInstance(lastMod);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean allowed = true;
            if (nextMod != null && nextMod.getBlackListMobClasses() != null) {
                for (Class<?> cl : nextMod.getBlackListMobClasses()) {
                    if (!entity.getClass().isAssignableFrom(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            if (lastMod != null && lastMod.getModsNotToMixWith() != null) {
                for (Class<?> cl : lastMod.getModsNotToMixWith()) {
                    if (!lastMod.containsModifierClass(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            possibleMods.remove(index);
            if (!allowed) continue;
            lastMod = nextMod;
            --number;
        }
        return lastMod;
    }

    public void addEntityModifiersByString(LivingEntity entity, String savedMods) {
        if (!InfernalMobsCore.getIsRareEntityOnline(entity)) {
            this.initIfNeeded(entity.level());
            MobModifier mod = this.stringToMobModifiers(savedMods);
            LOGGER.debug("reloading mods for {}: {}, mod instance {}", (Object)entity, (Object)savedMods, (Object)mod);
            if (mod != null) {
                SidedCache.getInfernalMobs(entity.level()).put(entity, mod);
                mod.onSpawningCompleteStoreModsAndBuffHealth(entity);
            } else {
                System.err.println("Infernal Mobs error, could not instantiate modifier " + savedMods);
            }
        }
    }

    private MobModifier stringToMobModifiers(String buffer) {
        MobModifier lastMod = null;
        String[] tokens = buffer.split("\\s");
        block2: for (int j = tokens.length - 1; j >= 0; --j) {
            String modName = tokens[j];
            MobModifier nextMod = null;
            for (Class<? extends MobModifier> c : this.mobMods) {
                try {
                    nextMod = lastMod == null ? c.getConstructor(new Class[0]).newInstance(new Object[0]) : c.getConstructor(MobModifier.class).newInstance(lastMod);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (nextMod == null || !nextMod.getModName().equals(modName)) continue;
                lastMod = nextMod;
                continue block2;
            }
        }
        return lastMod;
    }

    public void addRemoteEntityModifiers(net.minecraft.world.level.Level world, int entID, String mods) {
        Entity ent = world.getEntity(entID);
        if (ent != null) {
            this.addEntityModifiersByString((LivingEntity)ent, mods);
        }
    }

    public void dropLootForEnt(LivingEntity mob, MobModifier mods) {
        int xpDrop;
        for (int xpValue = 25; xpValue > 0; xpValue -= xpDrop) {
            xpDrop = ExperienceOrb.getExperienceValue((int)xpValue);
            mob.level().addFreshEntity((Entity)new ExperienceOrb(mob.level(), mob.getX(), mob.getY(), mob.getZ(), xpDrop));
        }
        this.dropRandomEnchantedItems(mob, mods);
    }

    private void dropRandomEnchantedItems(LivingEntity mob, MobModifier mods) {
        int prefix;
        int modStr = mods.getModSize();
        int n = modStr <= 5 ? 0 : (prefix = modStr <= 10 ? 1 : 2);
        while (modStr > 0) {
            ItemStack itemStack = this.getRandomItem(mob, prefix);
            if (itemStack != null) {
                Item item = itemStack.getItem();
                int usedStr = modStr - 5 > 0 ? 5 : modStr;
                this.enchantRandomly(mob.level(), itemStack, item.getEnchantmentValue(), usedStr);
                ItemEntity itemEnt = new ItemEntity(mob.level(), mob.getX(), mob.getY(), mob.getZ(), itemStack);
                mob.level().addFreshEntity((Entity)itemEnt);
                modStr -= 5;
                continue;
            }
            --modStr;
        }
    }

    private void enchantRandomly(net.minecraft.world.level.Level level, ItemStack itemStack, int itemEnchantability, int modStr) {
        Optional optional = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.ON_RANDOM_LOOT);
        Stream holderStream = optional.map(HolderSet::stream).orElseGet(() -> level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().map(e -> e));
        List enchantments = EnchantmentHelper.selectEnchantment((RandomSource)level.getRandom(), (ItemStack)itemStack, (int)itemEnchantability, (Stream)holderStream);
        Iterator iter = enchantments.iterator();
        for (int remainStr = (modStr + 1) / 2; iter.hasNext() && remainStr > 0; --remainStr) {
            EnchantmentInstance eData = (EnchantmentInstance)iter.next();
            itemStack.enchant(eData.enchantment, eData.level);
        }
    }

    private ItemStack getRandomItem(LivingEntity mob, int prefix) {
        List<ItemStack> list = prefix == 0 ? InfernalMobsCore.instance.lootItemDropsElite.getItemStackList() : (prefix == 1 ? InfernalMobsCore.instance.lootItemDropsUltra.getItemStackList() : InfernalMobsCore.instance.lootItemDropsInfernal.getItemStackList());
        return list.size() > 0 ? list.get(mob.level().random.nextInt(list.size())).copy() : null;
    }

    public void sendVelocityPacket(ServerPlayer target, float xVel, float yVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            VelocityPacket velocityPacket = new VelocityPacket(xVel, yVel, zVel);
            PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)velocityPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendKnockBackPacket(ServerPlayer target, float xVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            KnockBackPacket knockBackPacket = new KnockBackPacket(xVel, zVel);
            PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)knockBackPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendHealthPacket(LivingEntity mob) {
        HealthPacket healthPacket = new HealthPacket("", mob.getId(), mob.getHealth(), mob.getMaxHealth());
        PacketDistributor.sendToPlayersTrackingEntity((Entity)mob, (CustomPacketPayload)healthPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendHealthRequestPacket(String playerName, LivingEntity mob) {
        HealthPacket healthPacket = new HealthPacket(playerName, mob.getId(), 0.0f, 0.0f);
        PacketDistributor.sendToServer((CustomPacketPayload)healthPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendAirPacket(ServerPlayer target, int lastAir) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            AirPacket airPacket = new AirPacket(lastAir);
            PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)airPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post tick) {
        if (System.currentTimeMillis() > this.nextExistCheckTime) {
            this.nextExistCheckTime = System.currentTimeMillis() + 5000L;
            Map<LivingEntity, MobModifier> mobsmap = SidedCache.getInfernalMobs(tick.getLevel());
            mobsmap.keySet().stream().filter(this::filterMob).forEach(InfernalMobsCore::removeEntFromElites);
            this.resetModifiedPlayerEntitiesAsNeeded(tick.getLevel());
        }
        if (!tick.getLevel().isClientSide()) {
            this.infCheckA = null;
            this.infCheckB = null;
        }
    }

    private boolean filterMob(LivingEntity mob) {
        return !mob.isAlive();
    }

    private void resetModifiedPlayerEntitiesAsNeeded(net.minecraft.world.level.Level world) {
        Iterator<Map.Entry<String, Long>> iterator = this.modifiedPlayerTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (System.currentTimeMillis() <= entry.getValue() + 10000L) continue;
            String username = entry.getKey();
            for (Player player : world.players()) {
                if (!player.getName().getString().equals(username)) continue;
                for (Class<? extends MobModifier> c : this.mobMods) {
                    try {
                        MobModifier mod = c.getConstructor(new Class[0]).newInstance(new Object[0]);
                        mod.resetModifiedVictim(player);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            iterator.remove();
        }
    }

    public boolean getIsHealthBarDisabled() {
        return this.config.isDisableHealthBar();
    }

    public double getMobModHealthFactor() {
        return this.config.getModHealthFactor();
    }

    public float getLimitedDamage(float test) {
        return (float)Math.min((double)test, this.config.getMaxDamage());
    }

    public boolean getIsEntityAllowedTarget(Entity entity) {
        return entity.isAttackable() && entity.isAlive();
    }

    public boolean isInfiniteLoop(LivingEntity mob, Entity entity) {
        if (mob == this.infCheckA && entity == this.infCheckB || mob == this.infCheckB && entity == this.infCheckA) {
            return true;
        }
        this.infCheckA = mob;
        this.infCheckB = entity;
        return false;
    }

    public HashMap<String, Long> getModifiedPlayerTimes() {
        return this.modifiedPlayerTimes;
    }
}

