/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public abstract class AbstractTeleporter
extends MobModifier {
    public AbstractTeleporter() {
    }

    public AbstractTeleporter(MobModifier next) {
        super(next);
    }

    protected boolean tryTeleportWithTarget(LivingEntity mob, Entity targetEnt) {
        int attempts;
        double startX = mob.getX();
        double startY = mob.getY();
        double startZ = mob.getZ();
        if (mob.distanceTo(targetEnt) > 8.0f) {
            for (attempts = 0; attempts < 5; ++attempts) {
                if (!this.tryTeleportTowardsEntity(mob, targetEnt)) continue;
                this.playStartEffects(mob, startX, startY, startZ);
                return true;
            }
        }
        for (attempts = 0; attempts < 5; ++attempts) {
            if (!this.teleportRandomly(mob)) continue;
            this.playStartEffects(mob, startX, startY, startZ);
            return true;
        }
        return false;
    }

    protected boolean teleportRandomly(LivingEntity mob) {
        if (!mob.level().isClientSide() && mob.isAlive()) {
            double d0 = mob.getX() + (mob.getRandom().nextDouble() - 0.5) * 64.0;
            double d1 = mob.getY() + (double)(mob.getRandom().nextInt(64) - 32);
            double d2 = mob.getZ() + (mob.getRandom().nextDouble() - 0.5) * 64.0;
            return this.tryTeleportTo(mob, d0, d1, d2);
        }
        return false;
    }

    protected boolean tryTeleportTowardsEntity(LivingEntity mob, Entity targetEnt) {
        Vec3 vec3 = new Vec3(mob.getX() - targetEnt.getX(), mob.getY(0.5) - targetEnt.getEyeY(), mob.getZ() - targetEnt.getZ());
        vec3 = vec3.normalize();
        double d1 = mob.getX() + (mob.getRandom().nextDouble() - 0.5) * 8.0 - vec3.x * 16.0;
        double d2 = mob.getY() + (double)(mob.getRandom().nextInt(16) - 8) - vec3.y * 16.0;
        double d3 = mob.getZ() + (mob.getRandom().nextDouble() - 0.5) * 8.0 - vec3.z * 16.0;
        return this.tryTeleportTo(mob, d1, d2, d3);
    }

    protected boolean tryTeleportTo(LivingEntity mob, double x, double y, double z) {
        BlockPos.MutableBlockPos destination = new BlockPos.MutableBlockPos(x, y, z);
        while (destination.getY() > mob.level().getMinBuildHeight() && !mob.level().getBlockState((BlockPos)destination).blocksMotion()) {
            destination.move(Direction.DOWN);
        }
        BlockState destinationFloorState = mob.level().getBlockState((BlockPos)destination);
        boolean blocksMotion = destinationFloorState.blocksMotion();
        boolean isWater = destinationFloorState.getFluidState().is(FluidTags.WATER);
        if (blocksMotion && !isWater) {
            EntityTeleportEvent forgeEvent = this.getForgeEvent(mob, x, y, z);
            if (forgeEvent.isCanceled()) {
                return false;
            }
            Vec3 vec3 = mob.position();
            boolean teleportResult = mob.randomTeleport(forgeEvent.getTargetX(), forgeEvent.getTargetY(), forgeEvent.getTargetZ(), true);
            if (teleportResult) {
                mob.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)mob));
                if (!mob.isSilent()) {
                    this.playDestinationEffects(mob);
                }
            }
            return teleportResult;
        }
        return false;
    }

    protected void playStartEffects(LivingEntity mob, double x, double y, double z) {
    }

    protected void playDestinationEffects(LivingEntity mob) {
        mob.level().playSound(null, mob.xo, mob.yo, mob.zo, SoundEvents.ENDERMAN_TELEPORT, mob.getSoundSource(), 1.0f, 1.0f);
        mob.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
    }

    protected EntityTeleportEvent getForgeEvent(LivingEntity mob, double x, double y, double z) {
        return new EntityTeleportEvent((Entity)mob, x, y, z);
    }
}

