/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MIText;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TextHelper {
    public static final Style GRAY_TEXT = Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(true));
    public static final Style NUMBER_TEXT = Style.EMPTY.withColor(TextColor.fromRgb((int)16768637)).withItalic(Boolean.valueOf(false));
    public static final Style WATER_TEXT = Style.EMPTY.withColor(TextColor.fromRgb((int)3302655));
    public static final Style WARNING_TEXT = Style.EMPTY.withColor(ChatFormatting.RED);
    public static final Style MAX_TEMP_TEXT = Style.EMPTY.withColor(TextColor.fromRgb((int)14240286));
    public static final Style HEAT_CONDUCTION = Style.EMPTY.withColor(TextColor.fromRgb((int)29626));
    public static final Style NEUTRONS = Style.EMPTY.withColor(TextColor.fromRgb((int)2728745));
    public static final Style YELLOW_BOLD = Style.EMPTY.withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true));
    public static final Style YELLOW = Style.EMPTY.withColor(ChatFormatting.YELLOW);
    public static final Style RED = Style.EMPTY.withColor(ChatFormatting.RED);
    public static final Style GREEN = Style.EMPTY.withColor(ChatFormatting.GREEN);
    public static final String[] units = new String[]{"k", "M", "G", "T", "P", "E"};
    public static final long[] nums = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};

    public static String getAmount(double amount, long num) {
        double fract = amount / (double)num;
        if (fract < 10.0) {
            return String.format("%.3f", fract);
        }
        if (fract < 100.0) {
            return String.format("%.2f", fract);
        }
        return String.format("%.1f", fract);
    }

    public static Amount getAmountGeneric(Number number) {
        if (number instanceof Long) {
            Long l = (Long)number;
            return TextHelper.getAmount(l);
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return TextHelper.getAmount(i.intValue());
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return TextHelper.getAmount(d);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return TextHelper.getAmount(f.floatValue());
        }
        throw new IllegalArgumentException("Number " + String.valueOf(number) + " is neither long, int, double or float");
    }

    public static Amount getAmount(double amount) {
        if (amount < 100000.0) {
            return new Amount(TextHelper.getAmount(amount, 1L), "");
        }
        int i = 0;
        while (amount / (double)nums[i] >= 1000.0) {
            ++i;
        }
        return new Amount(TextHelper.getAmount(amount, nums[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(double amount, double max) {
        if (max < 1000.0) {
            return new MaxedAmount(TextHelper.getAmount(amount, 1L), TextHelper.getAmount(max, 1L), "");
        }
        int i = 0;
        while (max / (double)nums[i] >= 1000.0) {
            ++i;
        }
        return new MaxedAmount(TextHelper.getAmount(amount, nums[i]), TextHelper.getAmount(max, nums[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmountGeneric(Number amount, Number max) {
        if (amount instanceof Long) {
            Long l = (Long)amount;
            if (max instanceof Long) {
                Long m = (Long)max;
                return TextHelper.getMaxedAmount(l, m);
            }
        }
        if (amount instanceof Integer) {
            Integer i = (Integer)amount;
            if (max instanceof Integer) {
                Integer m = (Integer)max;
                return TextHelper.getMaxedAmount(i.intValue(), m.intValue());
            }
        }
        if (amount instanceof Double) {
            Double d = (Double)amount;
            if (max instanceof Double) {
                Double m = (Double)max;
                return TextHelper.getMaxedAmount(d, m);
            }
        }
        if (amount instanceof Float) {
            Float f = (Float)amount;
            if (max instanceof Float) {
                Float m = (Float)max;
                return TextHelper.getMaxedAmount(f.floatValue(), m.floatValue());
            }
        }
        throw new IllegalArgumentException("Number " + String.valueOf(amount) + " or " + String.valueOf(max) + " is neither long, int, double or float");
    }

    public static Amount getAmount(long amount) {
        if (amount < 100000L) {
            return new Amount(String.valueOf(amount), "");
        }
        int i = 0;
        while (amount / nums[i] >= 1000L) {
            ++i;
        }
        return new Amount(TextHelper.getAmount(amount, nums[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(long amount, long max) {
        if (max < 100000L) {
            return new MaxedAmount(String.valueOf(amount), String.valueOf(max), "");
        }
        int i = 0;
        while (max / nums[i] >= 1000L) {
            ++i;
        }
        return new MaxedAmount(TextHelper.getAmount(amount, nums[i]), TextHelper.getAmount(max, nums[i]), units[i]);
    }

    public static MutableComponent getEuTextMaxed(Number eu, Number max) {
        MaxedAmount amount = TextHelper.getMaxedAmountGeneric(eu, max);
        return MIText.EuMaxed.text(amount.digit(), amount.maxDigit(), amount.unit());
    }

    public static MutableComponent getEuText(double eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.Eu.text(amount.digit(), amount.unit());
    }

    public static MutableComponent getEuTextTick(double eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.EuT.text(amount.digit(), amount.unit());
    }

    public static MutableComponent getEuText(long eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.Eu.text(amount.digit(), amount.unit());
    }

    public static MutableComponent getEuTextTick(long eu) {
        Amount amount = TextHelper.getAmount(eu);
        return MIText.EuT.text(amount.digit(), amount.unit());
    }

    public static Component getEuTextTick(double eu, boolean style) {
        MutableComponent text = TextHelper.getEuTextTick(eu);
        if (style) {
            text.setStyle(NUMBER_TEXT);
        }
        return text;
    }

    public record Amount(String digit, String unit) {
    }

    public record MaxedAmount(String digit, String maxDigit, String unit) {
    }
}

