/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.client.MIRenderTypes;
import aztech.modern_industrialization.compat.sodium.SodiumCompat;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadBuffer;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.client.fluid.FluidVariantRendering;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RenderHelper {
    private static final ResourceLocation HATCH_PLACEMENT_OVERLAY_LOCATION = MI.id("block/hatch_placement_overlay");
    @Nullable
    private static OverlayQuads overlayQuads;
    private static final Supplier<BakedQuad[]> CUBE_QUADS;
    private static final float TANK_W = 0.0635f;
    public static final int FULL_LIGHT = 0xF000F0;
    private static final ResourceLocation LOCKED_TEXTURE_LOCATION;
    public static final BlockEntityWithoutLevelRenderer BLOCK_AND_ENTITY_RENDERER;

    public static void drawOverlay(PoseStack ms, MultiBufferSource vcp, int overlay) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(HATCH_PLACEMENT_OVERLAY_LOCATION);
        if (overlayQuads == null || overlayQuads.sprite() != sprite) {
            overlayQuads = new OverlayQuads(RenderHelper.buildOverlayQuads(sprite), sprite);
        }
        VertexConsumer vc = vcp.getBuffer(MIRenderTypes.cutoutHighlight());
        for (BakedQuad overlayQuad : RenderHelper.overlayQuads.quads) {
            vc.putBulkData(ms.last(), overlayQuad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, overlay);
        }
    }

    private static BakedQuad[] buildOverlayQuads(TextureAtlasSprite sprite) {
        BakedQuad[] overlayQuads = new BakedQuad[6];
        QuadBuffer emitter = new QuadBuffer();
        for (Direction direction : Direction.values()) {
            emitter.emit();
            emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            emitter.spriteBake(sprite, 4);
            overlayQuads[direction.get3DDataValue()] = emitter.toBakedQuad(sprite);
        }
        return overlayQuads;
    }

    public static void drawCube(PoseStack ms, MultiBufferSource vcp, float r, float g, float b, int light, int overlay) {
        VertexConsumer vc = vcp.getBuffer(MIRenderTypes.cutoutHighlight());
        for (BakedQuad cubeQuad : CUBE_QUADS.get()) {
            vc.putBulkData(ms.last(), cubeQuad, r, g, b, 1.0f, light, overlay);
        }
    }

    public static void drawFluidInTank(BlockEntity be, PoseStack ms, MultiBufferSource vcp, FluidVariant fluid, float fill) {
        RenderHelper.drawFluidInTank(be.getLevel(), be.getBlockPos(), ms, vcp, fluid, fill);
    }

    public static void drawFluidInTank(@Nullable Level world, BlockPos pos, PoseStack ms, MultiBufferSource vcp, FluidVariant fluid, float fill) {
        VertexConsumer vc = vcp.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)RenderType.translucent(), (boolean)false));
        TextureAtlasSprite sprite = FluidVariantRendering.getSprite(fluid);
        int color = FluidVariantRendering.getColor(fluid, (BlockAndTintGetter)world, pos);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        SodiumCompat.markSpriteActive(sprite);
        float topHeight = fill = 0.0635f + 0.873f * Math.min(1.0f, Math.max(fill, 0.0f));
        float bottomHeight = 0.0635f;
        if (fluid.getFluid().getFluidType().isLighterThanAir()) {
            topHeight = 0.9365f;
            bottomHeight = 1.0f - fill;
        }
        QuadBuffer emitter = new QuadBuffer();
        for (Direction direction : Direction.values()) {
            emitter.emit();
            if (direction.getAxis().isVertical()) {
                emitter.square(direction, 0.0635f, 0.0635f, 0.9365f, 0.9365f, direction == Direction.UP ? 1.0f - topHeight : bottomHeight);
            } else {
                emitter.square(direction, 0.0635f, bottomHeight, 0.9365f, topHeight, 0.0635f);
            }
            emitter.spriteBake(sprite, 4);
            emitter.color(-1, -1, -1, -1);
            vc.putBulkData(ms.last(), emitter.toBakedQuad(sprite), r, g, b, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    public static void drawFluidInGui(GuiGraphics guiGraphics, FluidVariant fluid, int i, int j) {
        RenderHelper.drawFluidInGui(guiGraphics, fluid, i, j, 16, 1.0f);
        RenderSystem.enableDepthTest();
    }

    public static void drawFluidInGui(GuiGraphics guiGraphics, FluidVariant fluid, float i, float j, int scale, float fractionUp) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite sprite = FluidVariantRendering.getSprite(fluid);
        int color = FluidVariantRendering.getColor(fluid);
        if (sprite == null) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float x0 = i;
        float y0 = j;
        float x1 = x0 + (float)scale;
        float y1 = y0 + (float)scale * fractionUp;
        float z = 0.5f;
        float u0 = sprite.getU0();
        float v1 = sprite.getV1();
        float v0 = v1 + (sprite.getV0() - v1) * fractionUp;
        float u1 = sprite.getU1();
        Matrix4f model = guiGraphics.pose().last().pose();
        bufferBuilder.addVertex(model, x0, y1, z).setUv(u0, v1).setColor(r, g, b, 1.0f);
        bufferBuilder.addVertex(model, x1, y1, z).setUv(u1, v1).setColor(r, g, b, 1.0f);
        bufferBuilder.addVertex(model, x1, y0, z).setUv(u1, v0).setColor(r, g, b, 1.0f);
        bufferBuilder.addVertex(model, x0, y0, z).setUv(u0, v0).setColor(r, g, b, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.enableDepthTest();
        SodiumCompat.markSpriteActive(sprite);
    }

    public static boolean isPointWithinRectangle(int xStart, int yStart, int width, int height, double pointX, double pointY) {
        return pointX >= (double)(xStart - 1) && pointX < (double)(xStart + width + 1) && pointY >= (double)(yStart - 1) && pointY < (double)(yStart + height + 1);
    }

    public static void quadWithAlpha(VertexConsumer consumer, PoseStack.Pose matrixEntry, BakedQuad quad, float red, float green, float blue, float alpha, int light, int overlay) {
        consumer.putBulkData(matrixEntry, quad, red, green, blue, alpha, light, overlay);
    }

    public static void drawLockedTexture(BlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, int colorRgb) {
        VertexConsumer vc = vertexConsumers.getBuffer(Sheets.cutoutBlockSheet());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(LOCKED_TEXTURE_LOCATION);
        BlockPos pos = entity.getBlockPos();
        BlockState state = entity.getBlockState();
        float r = (float)(colorRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorRgb & 0xFF) / 255.0f;
        QuadBuffer emitter = new QuadBuffer();
        for (Direction direction : Direction.values()) {
            if (direction.getAxis().isVertical() || entity.getLevel() != null && !Block.shouldRenderFace((BlockState)state, (BlockGetter)entity.getLevel(), (BlockPos)pos, (Direction)direction.getOpposite(), (BlockPos)pos.relative(direction.getOpposite()))) continue;
            emitter.emit();
            emitter.square(direction, 1.0f, 0.0f, 0.0f, 1.0f, 1.015f);
            emitter.spriteBake(sprite, 4);
            vc.putBulkData(matrices.last(), emitter.toBakedQuad(sprite), r, g, b, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    public static void renderVoxelShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        for (AABB aabb : shape.toAabbs()) {
            LevelRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)consumer, (VoxelShape)Shapes.create((AABB)aabb), (double)x, (double)y, (double)z, (float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void renderAndDecorateItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        RenderHelper.renderAndDecorateItem(guiGraphics, Minecraft.getInstance().font, stack, x, y);
    }

    public static void renderAndDecorateItem(GuiGraphics guiGraphics, Font font, ItemStack stack, int x, int y) {
        RenderHelper.renderAndDecorateItem(guiGraphics, font, stack, x, y, null);
    }

    public static void renderAndDecorateItem(GuiGraphics guiGraphics, Font font, ItemStack stack, int x, int y, @Nullable String text) {
        guiGraphics.renderItem(stack, x, y);
        guiGraphics.renderItemDecorations(font, stack, x, y, text);
    }

    public static List<FormattedCharSequence> splitTooltip(List<Component> components) {
        ArrayList<FormattedCharSequence> charSequences = new ArrayList<FormattedCharSequence>();
        for (Component component : components) {
            charSequences.addAll(Tooltip.splitTooltip((Minecraft)Minecraft.getInstance(), (Component)component));
        }
        return charSequences;
    }

    static {
        CUBE_QUADS = Suppliers.memoize(() -> {
            BakedQuad[] cubeQuads = new BakedQuad[6];
            for (Direction direction : Direction.values()) {
                QuadBuffer emitter = new QuadBuffer();
                emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                cubeQuads[direction.get3DDataValue()] = emitter.toBakedQuad(null);
            }
            return cubeQuads;
        });
        LOCKED_TEXTURE_LOCATION = MI.id("block/locked");
        BLOCK_AND_ENTITY_RENDERER = new BlockEntityWithoutLevelRenderer(null, null){

            public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
                Item item = stack.getItem();
                if (!(item instanceof BlockItem)) {
                    throw new IllegalArgumentException("Stack must be a block item!");
                }
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                if (!(block instanceof EntityBlock)) {
                    throw new IllegalArgumentException("Block must be an entity block!");
                }
                EntityBlock entityBlock = (EntityBlock)block;
                BlockEntity fakeBlockEntity = entityBlock.newBlockEntity(BlockPos.ZERO, blockItem.getBlock().defaultBlockState());
                Objects.requireNonNull(fakeBlockEntity);
                fakeBlockEntity.applyComponentsFromItemStack(stack);
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(fakeBlockEntity.getBlockState(), matrices, vertexConsumers, light, overlay);
                BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(fakeBlockEntity);
                Objects.requireNonNull(renderer).render(fakeBlockEntity, 0.0f, matrices, vertexConsumers, light, overlay);
            }
        };
    }

    private record OverlayQuads(BakedQuad[] quads, TextureAtlasSprite sprite) {
    }
}

