/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabricrendering;

import java.util.Arrays;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;

public abstract class ModelHelper {
    public static final int NULL_FACE_ID = 6;
    private static final Direction[] FACES = Arrays.copyOf(Direction.values(), 7);
    public static final ItemTransform TRANSFORM_BLOCK_GUI = ModelHelper.makeTransform(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    public static final ItemTransform TRANSFORM_BLOCK_GROUND = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
    public static final ItemTransform TRANSFORM_BLOCK_FIXED = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    public static final ItemTransform TRANSFORM_BLOCK_3RD_PERSON_RIGHT = ModelHelper.makeTransform(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
    public static final ItemTransform TRANSFORM_BLOCK_1ST_PERSON_RIGHT = ModelHelper.makeTransform(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final ItemTransform TRANSFORM_BLOCK_1ST_PERSON_LEFT = ModelHelper.makeTransform(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final ItemTransforms MODEL_TRANSFORM_BLOCK = new ItemTransforms(TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_1ST_PERSON_LEFT, TRANSFORM_BLOCK_1ST_PERSON_RIGHT, ItemTransform.NO_TRANSFORM, TRANSFORM_BLOCK_GUI, TRANSFORM_BLOCK_GROUND, TRANSFORM_BLOCK_FIXED);

    private ModelHelper() {
    }

    public static int toFaceIndex(Direction face) {
        return face == null ? 6 : face.get3DDataValue();
    }

    @Contract(value="null -> null")
    public static Direction faceFromIndex(int faceIndex) {
        return FACES[faceIndex];
    }

    private static ItemTransform makeTransform(float rotationX, float rotationY, float rotationZ, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float scaleZ) {
        Vector3f translation = new Vector3f(translationX, translationY, translationZ);
        translation.mul(0.0625f);
        translation = new Vector3f(Mth.clamp((float)translation.x, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.y, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.z, (float)-5.0f, (float)5.0f));
        return new ItemTransform(new Vector3f(rotationX, rotationY, rotationZ), translation, new Vector3f(scaleX, scaleY, scaleZ));
    }
}

