/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotFluidHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import net.minecraft.world.level.Level;

public class FluidNetworkExtensionTank
extends SlotFluidHandler {
    private static final int NOT_CLAIMED = -1;
    private int lastClaimTick = -1;

    public FluidNetworkExtensionTank(SingleSlotStorage<FluidVariant> storage) {
        super(storage);
    }

    public boolean tryClaimForNetwork(Level level, FluidVariant networkFluid) {
        if (this.storage.getAmount() != 0L && !((FluidVariant)this.storage.getResource()).equals(networkFluid)) {
            return false;
        }
        try (Transaction tx = Transaction.openOuter();){
            this.storage.extract(networkFluid, this.storage.getAmount(), tx);
            long inserted = this.storage.insert(networkFluid, this.storage.getCapacity(), tx);
            if (inserted != this.storage.getCapacity()) {
                boolean bl = false;
                return bl;
            }
        }
        int tick = level.getServer().getTickCount();
        if (tick > this.lastClaimTick) {
            this.lastClaimTick = tick;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.storage.getAmount() == 0L) {
            return;
        }
        try (Transaction tx = Transaction.openOuter();){
            this.storage.extract((FluidVariant)this.storage.getResource(), this.storage.getAmount(), tx);
            tx.commit();
        }
        if (this.storage.getAmount() > 0L) {
            throw new IllegalStateException("Internal MI error: extension %s should be empty after clearing it.".formatted(this));
        }
    }

    public void releaseFromNetwork(FluidVariant fluid, long amount) {
        if (this.storage.getAmount() > 0L) {
            throw new IllegalStateException("Internal MI error: extension %s should be empty when being released.".formatted(this));
        }
        this.lastClaimTick = -1;
        if (fluid.isBlank() && this.storage.getAmount() != 0L) {
            throw new IllegalStateException("Internal MI error: releasing extension %s from network with non-empty tank.".formatted(this));
        }
        try (Transaction tx = Transaction.openOuter();){
            long inserted = this.storage.insert(fluid, amount, tx);
            tx.commit();
            if (inserted != amount) {
                throw new IllegalStateException("Internal MI error: releasing extension %s, only inserted %d out of %d.".formatted(this, inserted, amount));
            }
        }
    }

    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    protected boolean disallowIo() {
        return this.lastClaimTick != -1;
    }

    public String toString() {
        return "FluidNetworkExtensionTank{" + String.valueOf(this.storage) + "}";
    }
}

