/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public interface INuclearComponent<T extends TransferVariant> {
    public double getHeatConduction();

    public INeutronBehaviour getNeutronBehaviour();

    public T getVariant();

    default public T getNeutronProduct() {
        return null;
    }

    default public long getNeutronProductAmount() {
        return 0L;
    }

    default public double getNeutronProductProbability() {
        return 1.0;
    }

    default public int getMaxTemperature() {
        return Integer.MAX_VALUE;
    }

    public static ResourceLocation getEmiRecipeId(INuclearComponent<?> component, String category, String type) {
        Object obj = component.getVariant();
        Objects.requireNonNull(obj);
        Object obj2 = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemVariant.class, FluidVariant.class, TransferVariant.class}, obj2, n)) {
            case 0 -> {
                ItemVariant itemVariant = (ItemVariant)obj2;
                yield BuiltInRegistries.ITEM.getKey((Object)itemVariant.getItem()).withPrefix("/" + category + "/item/").withSuffix("/" + type);
            }
            case 1 -> {
                FluidVariant fluidVariant = (FluidVariant)obj2;
                yield BuiltInRegistries.FLUID.getKey((Object)fluidVariant.getFluid()).withPrefix("/" + category + "/fluid/").withSuffix("/" + type);
            }
            default -> {
                Object object = obj2;
                throw new IllegalArgumentException("Unknown component variant " + String.valueOf(object));
            }
        };
    }
}

