/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class ShapelessRecipeBuilder
implements MaterialRecipeBuilder {
    public final String recipeId;
    private final MaterialBuilder.RecipeContext context;
    private boolean canceled = false;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();

    public ShapelessRecipeBuilder(MaterialBuilder.RecipeContext context, PartKeyProvider result, int count, String id) {
        this.recipeId = "craft/" + id;
        this.context = context;
        MaterialItemPart output = context.getPart(result);
        if (output == null) {
            this.result = null;
            this.canceled = true;
        } else {
            this.result = new ItemStack((ItemLike)output.asItem(), count);
        }
        context.addRecipe(this);
    }

    public ShapelessRecipeBuilder addPart(PartKeyProvider part) {
        if (this.context.getPart(part) != null) {
            this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{this.context.getPart(part).asItem()}));
        } else {
            this.canceled = true;
        }
        return this;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void save(RecipeOutput recipeOutput) {
        if (!this.canceled) {
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            recipeOutput.accept(MI.id(fullId), (Recipe)new ShapelessRecipe("", CraftingBookCategory.MISC, this.result, this.ingredients), null);
        }
    }
}

