/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGuiClient;
import aztech.modern_industrialization.util.TextHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CraftingMultiblockGuiClient
implements GuiComponentClient {
    public boolean isShapeValid;
    boolean hasActiveRecipe;
    float progress;
    int efficiencyTicks;
    int maxEfficiencyTicks;
    long currentRecipeEu;
    long baseRecipeEu;
    int remainingOverclockTicks;

    public CraftingMultiblockGuiClient(RegistryFriendlyByteBuf buf) {
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.isShapeValid = buf.readBoolean();
        if (this.isShapeValid) {
            this.hasActiveRecipe = buf.readBoolean();
            if (this.hasActiveRecipe) {
                this.progress = buf.readFloat();
                this.efficiencyTicks = buf.readInt();
                this.maxEfficiencyTicks = buf.readInt();
                this.currentRecipeEu = buf.readLong();
                this.baseRecipeEu = buf.readLong();
            }
        }
        this.remainingOverclockTicks = buf.readVarInt();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        private static final ResourceLocation TEXTURE = MI.id("textures/gui/container/multiblock_info.png");

        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            Minecraft minecraftClient = Minecraft.getInstance();
            guiGraphics.blit(TEXTURE, x + 5, y + 16, 0.0f, 0.0f, 166, 80, 166, 80);
            Font font = minecraftClient.font;
            int deltaY = 23;
            guiGraphics.drawString(font, (Component)(CraftingMultiblockGuiClient.this.isShapeValid ? MIText.MultiblockShapeValid.text() : MIText.MultiblockShapeInvalid.text()), x + 10, y + deltaY, CraftingMultiblockGuiClient.this.isShapeValid ? 0xFFFFFF : 0xFF0000, false);
            deltaY += 11;
            if (CraftingMultiblockGuiClient.this.isShapeValid) {
                guiGraphics.drawString(font, (Component)MIText.MultiblockStatusActive.text(), x + 10, y + deltaY, 0xFFFFFF, false);
                deltaY += 11;
                if (CraftingMultiblockGuiClient.this.hasActiveRecipe) {
                    guiGraphics.drawString(font, (Component)MIText.Progress.text(String.format("%.1f", Float.valueOf(CraftingMultiblockGuiClient.this.progress * 100.0f)) + " %"), x + 10, y + deltaY, 0xFFFFFF, false);
                    deltaY += 11;
                    if (CraftingMultiblockGuiClient.this.efficiencyTicks != 0 || CraftingMultiblockGuiClient.this.maxEfficiencyTicks != 0) {
                        guiGraphics.drawString(font, (Component)MIText.EfficiencyTicks.text(CraftingMultiblockGuiClient.this.efficiencyTicks, CraftingMultiblockGuiClient.this.maxEfficiencyTicks), x + 10, y + deltaY, 0xFFFFFF, false);
                        deltaY += 11;
                    }
                    guiGraphics.drawString(font, (Component)MIText.BaseEuRecipe.text(TextHelper.getEuTextTick(CraftingMultiblockGuiClient.this.baseRecipeEu)), x + 10, y + deltaY, 0xFFFFFF, false);
                    guiGraphics.drawString(font, (Component)MIText.CurrentEuRecipe.text(TextHelper.getEuTextTick(CraftingMultiblockGuiClient.this.currentRecipeEu)), x + 10, y + (deltaY += 11), 0xFFFFFF, false);
                    deltaY += 11;
                }
            }
            if (CraftingMultiblockGuiClient.this.remainingOverclockTicks > 0) {
                guiGraphics.drawString(font, GunpowderOverclockGuiClient.Renderer.formatOverclock(CraftingMultiblockGuiClient.this.remainingOverclockTicks), x + 10, y + deltaY, 0xFFFFFF, false);
            }
        }
    }
}

