/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class OrientationComponent
implements IComponent {
    public Direction facingDirection = Direction.NORTH;
    public Direction outputDirection = null;
    public boolean extractItems = false;
    public boolean extractFluids = false;
    public final Params params;
    private final BlockEntity machine;

    public OrientationComponent(Params params, BlockEntity machine) {
        this.params = params;
        if (params.hasOutput) {
            this.outputDirection = Direction.NORTH;
        }
        this.machine = machine;
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.facingDirection = Direction.from3DDataValue((int)tag.getInt("facingDirection"));
        if (this.params.hasOutput) {
            this.outputDirection = Direction.from3DDataValue((int)tag.getInt("outputDirection"));
        }
        this.extractItems = tag.getBoolean("extractItems");
        this.extractFluids = tag.getBoolean("extractFluids");
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("facingDirection", this.facingDirection.get3DDataValue());
        if (this.params.hasOutput) {
            tag.putInt("outputDirection", this.outputDirection.get3DDataValue());
            tag.putBoolean("extractItems", this.extractItems);
            tag.putBoolean("extractFluids", this.extractFluids);
        }
    }

    public void writeModelData(MachineModelClientData data) {
        data.frontDirection = this.facingDirection;
        if (this.params.hasOutput) {
            data.outputDirection = this.outputDirection;
            data.itemAutoExtract = this.extractItems;
            data.fluidAutoExtract = this.extractFluids;
        }
    }

    public boolean useWrench(Player player, InteractionHand hand, Direction face) {
        if (player.isShiftKeyDown()) {
            if (this.params.hasOutput) {
                this.outputDirection = face;
                this.machine.invalidateCapabilities();
                return true;
            }
        } else {
            if (this.params.canBeVertical || face.getAxis().isHorizontal()) {
                this.facingDirection = face;
            }
            return true;
        }
        return false;
    }

    public void onPlaced(@Nullable LivingEntity placer, ItemStack itemStack) {
        Direction dir = placer != null ? (this.params.canBeVertical ? placer.getNearestViewDirection() : placer.getDirection()) : Direction.NORTH;
        this.facingDirection = dir.getOpposite();
        if (this.params.hasOutput) {
            this.outputDirection = placer != null ? placer.getNearestViewDirection() : Direction.NORTH;
        }
    }

    public static class Params {
        public final boolean hasOutput;
        public final boolean hasExtractItems;
        public final boolean hasExtractFluids;
        public final boolean canBeVertical;

        public Params(boolean hasOutput, boolean hasExtractItems, boolean hasExtractFluids, boolean canBeVertical) {
            this.hasOutput = hasOutput;
            this.hasExtractItems = hasExtractItems;
            this.hasExtractFluids = hasExtractFluids;
            this.canBeVertical = canBeVertical;
        }

        public Params(boolean hasOutput, boolean hasExtractItems, boolean hasExtractFluids) {
            this(hasOutput, hasExtractItems, hasExtractFluids, false);
        }
    }
}

