/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractElectricCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ElectricBlastFurnaceBlockEntity
extends AbstractElectricCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    public static final List<Tier> tiers;
    public static final Map<ResourceLocation, Tier> tiersByCoil;
    private static final ShapeTemplate[] shapeTemplates;
    private final UpgradeComponent upgrades = new UpgradeComponent();
    private final OverdriveComponent overdrive = new OverdriveComponent();

    public ElectricBlastFurnaceBlockEntity(BEP bep) {
        super(bep, "electric_blast_furnace", new OrientationComponent.Params(false, false, false), shapeTemplates);
        this.registerComponents(this.upgrades, this.overdrive);
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withOverdrive(this.overdrive));
        List<Component> tierComponents = tiers.stream().map(Tier::getDisplayName).toList();
        this.registerGuiComponent(new ShapeSelection.Server(new ShapeSelection.Behavior(){

            @Override
            public void handleClick(int clickedLine, int delta) {
                ElectricBlastFurnaceBlockEntity.this.activeShape.incrementShape(ElectricBlastFurnaceBlockEntity.this, delta);
            }

            @Override
            public int getCurrentIndex(int line) {
                return ElectricBlastFurnaceBlockEntity.this.activeShape.getActiveShapeIndex();
            }
        }, new ShapeSelection.LineInfo(tiers.size(), tierComponents, true)));
    }

    @Override
    public MachineRecipeType recipeType() {
        return MIMachineRecipeTypes.BLAST_FURNACE;
    }

    @Override
    public boolean banRecipe(MachineRecipe recipe) {
        int index = this.activeShape.getActiveShapeIndex();
        return (long)recipe.eu > this.getMaxRecipeEu() || (long)recipe.eu > ElectricBlastFurnaceBlockEntity.tiers.get((int)index).maxBaseEu;
    }

    @Override
    public long getBaseRecipeEu() {
        return MachineTier.MULTIBLOCK.getBaseEu();
    }

    @Override
    public long getMaxRecipeEu() {
        return (long)MachineTier.MULTIBLOCK.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    @Override
    public boolean isOverdriving() {
        return this.overdrive.shouldOverdrive();
    }

    @Override
    public ShapeTemplate getBigShape() {
        return shapeTemplates[shapeTemplates.length - 1];
    }

    public static void registerReiShapes() {
        for (int i = 0; i < shapeTemplates.length; ++i) {
            ReiMachineRecipes.registerMultiblockShape("electric_blast_furnace", shapeTemplates[i], ElectricBlastFurnaceBlockEntity.tiers.get((int)i).coilBlockId.getPath());
        }
    }

    static {
        ArrayList<Tier> registrationTiers = new ArrayList<Tier>();
        registrationTiers.add(new Tier(MI.id("cupronickel_coil"), 32L, "Cupronickel"));
        registrationTiers.add(new Tier(MI.id("kanthal_coil"), 128L, "Kanthal"));
        KubeJSProxy.instance.fireAddEbfTiersEvent(tier -> {
            Preconditions.checkArgument((tier.maxBaseEu > 4L ? 1 : 0) != 0, (Object)"EBF tier EU/t must be greater than 4.");
            for (Tier t : registrationTiers) {
                if (t.coilBlockId.equals((Object)tier.coilBlockId)) {
                    throw new IllegalArgumentException("EBF tier with coil " + String.valueOf(tier.coilBlockId) + " is already registered.");
                }
                if (t.coilBlockId.getPath().equals(tier.coilBlockId.getPath())) {
                    throw new IllegalArgumentException("EBF tier with coil " + String.valueOf(tier.coilBlockId) + " has the same path as an already registered tier.");
                }
                if (t.maxBaseEu != tier.maxBaseEu) continue;
                throw new IllegalArgumentException("EBF tier with max " + tier.maxBaseEu + " EU/t is already registered.");
            }
            registrationTiers.add((Tier)tier);
        });
        registrationTiers.sort(Comparator.comparingLong(Tier::maxBaseEu));
        tiers = Collections.unmodifiableList(registrationTiers);
        tiersByCoil = tiers.stream().collect(Collectors.toMap(Tier::coilBlockId, t -> t));
        shapeTemplates = new ShapeTemplate[tiers.size()];
        for (int i = 0; i < tiers.size(); ++i) {
            ShapeTemplate ebfShape;
            Tier tier2 = tiers.get(i);
            SimpleMember invarCasings = SimpleMember.forBlock((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id("heatproof_machine_casing")));
            SimpleMember coilsBlocks = SimpleMember.forBlockId(tier2.coilBlockId());
            HatchFlags ebfHatches = new HatchFlags.Builder().with(HatchType.ITEM_INPUT, HatchType.ITEM_OUTPUT, HatchType.FLUID_INPUT, HatchType.FLUID_OUTPUT, HatchType.ENERGY_INPUT).build();
            ElectricBlastFurnaceBlockEntity.shapeTemplates[i] = ebfShape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(0, invarCasings, false, ebfHatches).add3by3(1, coilsBlocks, true, null).add3by3(2, coilsBlocks, true, null).add3by3(3, invarCasings, false, ebfHatches).build();
        }
    }

    public record Tier(ResourceLocation coilBlockId, long maxBaseEu, String englishName) {
        public String getTranslationKey() {
            return "ebf_tier.modern_industrialization." + this.coilBlockId.getPath();
        }

        public Component getDisplayName() {
            return Component.translatable((String)this.getTranslationKey());
        }
    }
}

