/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.api.machine.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Tickable;

public abstract class AbstractCraftingMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
MultiblockInventoryComponentHolder,
CrafterComponentHolder {
    private OperatingState operatingState = OperatingState.NOT_MATCHED;
    protected final ActiveShapeComponent activeShape;
    protected final MultiblockInventoryComponent inventory;
    protected final CrafterComponent crafter;
    private final IsActiveComponent isActive;

    public AbstractCraftingMultiblockBlockEntity(BEP bep, String name, OrientationComponent.Params orientationParams, ShapeTemplate[] shapeTemplates) {
        super(bep, new MachineGuiParameters.Builder(name, false).backgroundHeight(200).build(), orientationParams);
        this.activeShape = new ActiveShapeComponent(shapeTemplates);
        this.inventory = new MultiblockInventoryComponent();
        this.crafter = new CrafterComponent(this, this.inventory, this.getBehavior());
        this.isActive = new IsActiveComponent();
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new ReiSlotLocking.Server(this.crafter::lockRecipe, () -> this.operatingState != OperatingState.NOT_MATCHED);
        this.registerGuiComponent(serverArray);
        this.registerComponents(this.activeShape, this.crafter, this.isActive);
    }

    protected abstract CrafterComponent.Behavior getBehavior();

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    @Override
    public MultiblockInventoryComponent getMultiblockInventoryComponent() {
        return this.inventory;
    }

    @Override
    public CrafterComponent getCrafterComponent() {
        return this.crafter;
    }

    @Override
    public final MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getMachineModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActive.isActive);
    }

    @Override
    public final void tick() {
        if (!this.level.isClientSide) {
            this.link();
            boolean newActive = false;
            if (this.operatingState == OperatingState.TRYING_TO_RESUME && this.crafter.tryContinueRecipe()) {
                this.operatingState = OperatingState.NORMAL_OPERATION;
            }
            if (this.operatingState == OperatingState.NORMAL_OPERATION) {
                if (this.crafter.tickRecipe()) {
                    newActive = true;
                }
            } else {
                this.crafter.decreaseEfficiencyTicks();
            }
            this.isActive.updateActive(newActive, this);
        }
        this.tickExtra();
    }

    public void tickExtra() {
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        this.operatingState = OperatingState.NOT_MATCHED;
        if (shapeMatcher.isMatchSuccessful()) {
            this.inventory.rebuild(shapeMatcher);
            this.operatingState = OperatingState.TRYING_TO_RESUME;
        }
    }

    private static enum OperatingState {
        NOT_MATCHED,
        TRYING_TO_RESUME,
        NORMAL_OPERATION;

    }
}

