/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.diesel_tools;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class DieselToolItem
extends Item
implements DynamicToolItem {
    public static final int CAPACITY = 4000;
    private final double damage;

    public DieselToolItem(Item.Properties settings, double damage) {
        super(settings.stacksTo(1).rarity(Rarity.UNCOMMON).component(MIComponents.SILK_TOUCH, (Object)true));
        this.damage = damage;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
            FluidFuelItemHelper.decrement(stack);
        }
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        FluidFuelItemHelper.decrement(stack);
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state) && FluidFuelItemHelper.getAmount(stack) > 0 && !state.is(Tiers.NETHERITE.getIncorrectBlocksForDrops())) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.isSupportedBlock(stack, state)) {
            return this.getMiningSpeedMultiplier(stack);
        }
        return 1.0f;
    }

    private float getMiningSpeedMultiplier(ItemStack stack) {
        FluidVariant fluid;
        int burnTicks;
        long amount = FluidFuelItemHelper.getAmount(stack);
        if (amount > 0L && (burnTicks = FluidFuel.getEu((fluid = FluidFuelItemHelper.getFluid(stack)).getFluid())) > 0) {
            return 1.0f + (float)burnTicks / 8.0f;
        }
        return 1.0f;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        if (FluidFuelItemHelper.getAmount(stack) > 0) {
            return ItemHelper.getToolModifiers(this.damage * (double)FluidFuel.getEu(FluidFuelItemHelper.getFluid(stack).getFluid()) / 600.0);
        }
        return ItemAttributeModifiers.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FluidFuelItemHelper.appendTooltip(stack, tooltip, 4000L);
        if (context.registries() != null) {
            HolderLookup.RegistryLookup enchantmentRegistry = context.registries().lookupOrThrow(Registries.ENCHANTMENT);
            tooltip.add((Component)MIText.MiningMode.text(((Enchantment)((Holder.Reference)enchantmentRegistry.get(DieselToolItem.isFortune(stack) ? Enchantments.FORTUNE : Enchantments.SILK_TOUCH).orElseThrow()).value()).description().copy().setStyle(TextHelper.NUMBER_TEXT)).setStyle(TextHelper.GRAY_TEXT.withItalic(Boolean.valueOf(false))));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        Fluid fluid = FluidFuelItemHelper.getFluid(stack).getFluid();
        if (fluid instanceof MIFluid) {
            MIFluid cf = (MIFluid)fluid;
            return cf.color;
        }
        return 0;
    }

    public double getDurabilityBarProgress(ItemStack stack) {
        return (double)FluidFuelItemHelper.getAmount(stack) / 4000.0;
    }

    private static boolean isFortune(ItemStack stack) {
        return (Boolean)stack.getOrDefault(MIComponents.SILK_TOUCH, (Object)false) == false;
    }

    private static void setFortune(ItemStack stack, boolean fortune) {
        stack.set(MIComponents.SILK_TOUCH, (Object)(!fortune ? 1 : 0));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && user.isShiftKeyDown()) {
            ItemStack stack;
            DieselToolItem.setFortune(stack, !DieselToolItem.isFortune(stack = user.getItemInHand(hand)));
            if (!world.isClientSide) {
                user.displayClientMessage((Component)(DieselToolItem.isFortune(stack) ? MIText.ToolSwitchedFortune.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        return super.use(world, user, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level w = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = w.getBlockState(pos);
        Player player = context.getPlayer();
        if (FluidFuelItemHelper.getAmount(stack) > 0) {
            BlockState newState;
            Block newBlock;
            if (stack.is(ItemTags.AXES) && (newBlock = StrippingAccess.getStrippedBlocks().get(state.getBlock())) != null) {
                w.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!w.isClientSide) {
                    w.setBlock(pos, (BlockState)newBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))), 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return InteractionResult.sidedSuccess((boolean)w.isClientSide);
            }
            if (stack.is(ItemTags.SHOVELS) && (newState = PathingAccess.getPathStates().get(state.getBlock())) != null) {
                w.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!w.isClientSide) {
                    w.setBlock(pos, newState, 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return InteractionResult.sidedSuccess((boolean)w.isClientSide);
            }
            if (stack.is(ItemTags.HOES)) {
                // empty if block
            }
        }
        return super.useOn(context);
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.getAllEnchantments(stack, (HolderLookup.RegistryLookup<Enchantment>)enchantment.unwrapLookup()).getLevel(enchantment);
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (FluidFuelItemHelper.getAmount(stack) > 0) {
            if (!DieselToolItem.isFortune(stack)) {
                lookup.get(Enchantments.SILK_TOUCH).ifPresent(h -> map.set((Holder)h, ((Enchantment)h.value()).getMaxLevel()));
            } else {
                lookup.get(Enchantments.FORTUNE).ifPresent(h -> map.set((Holder)h, ((Enchantment)h.value()).getMaxLevel()));
            }
        }
        return map.toImmutable();
    }

    public boolean isFoil(ItemStack pStack) {
        return FluidFuelItemHelper.getAmount(pStack) > 0;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        int defaultMb = 100;
        float speedMultiplier = this.getMiningSpeedMultiplier(stack);
        int costMb = (int)(100.0f / speedMultiplier);
        if (FluidFuelItemHelper.getAmount(stack) >= costMb && stack.is(Tags.Items.TOOLS_SHEAR) && interactionTarget instanceof Shearable) {
            Shearable shearable = (Shearable)interactionTarget;
            if (!interactionTarget.level().isClientSide && shearable.readyForShearing()) {
                shearable.shear(SoundSource.PLAYERS);
                interactionTarget.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static class StrippingAccess
    extends AxeItem {
        private StrippingAccess(Tier material, Item.Properties settings) {
            super(material, settings);
        }

        public static Map<Block, Block> getStrippedBlocks() {
            return STRIPPABLES;
        }
    }

    private static class PathingAccess
    extends ShovelItem {
        private PathingAccess(Tier material, Item.Properties settings) {
            super(material, settings);
        }

        public static Map<Block, BlockState> getPathStates() {
            return FLATTENABLES;
        }
    }
}

