/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class HeatExchangerRecipesProvider
extends MIRecipesProvider {
    public HeatExchangerRecipesProvider(PackOutput packOutput) {
        super(packOutput);
    }

    private static String fluidToString(FluidLike f, boolean id) {
        if (f.asFluid() == Fluids.WATER) {
            return (id ? "minecraft:" : "") + "water";
        }
        if (f.asFluid() == Fluids.LAVA) {
            return (id ? "minecraft:" : "") + "lava";
        }
        return ((FluidDefinition)f).getResourceAsString(id);
    }

    public void buildRecipes(RecipeOutput consumer) {
        FluidLike[] hots = new FluidLike[]{MIFluids.STEAM, MIFluids.HEAVY_WATER_STEAM, MIFluids.HIGH_PRESSURE_HEAVY_WATER_STEAM, MIFluids.HIGH_PRESSURE_STEAM};
        FluidLike[] cold = new FluidLike[]{FluidLike.of((Fluid)Fluids.WATER), MIFluids.HEAVY_WATER, MIFluids.HIGH_PRESSURE_HEAVY_WATER, MIFluids.HIGH_PRESSURE_WATER};
        int[] amount = new int[]{1, 1, 8, 8};
        int amountBaseHot = 16000;
        int amountBaseCold = 1000;
        for (int i = 0; i < hots.length; ++i) {
            for (int j = 0; j < cold.length; ++j) {
                if (i == j) continue;
                MachineRecipeBuilder recipe = new MachineRecipeBuilder(MIMachineRecipeTypes.HEAT_EXCHANGER, 2, 300);
                String path = "heat_exchanger/" + HeatExchangerRecipesProvider.fluidToString(hots[i], false) + "_with_" + HeatExchangerRecipesProvider.fluidToString(cold[j], false);
                recipe.addFluidInput(HeatExchangerRecipesProvider.fluidToString(hots[i], true), amountBaseHot / amount[i]);
                recipe.addFluidInput(HeatExchangerRecipesProvider.fluidToString(cold[j], true), amountBaseCold / amount[j]);
                recipe.addFluidOutput(HeatExchangerRecipesProvider.fluidToString(cold[i], true), amountBaseCold / amount[i]);
                recipe.addFluidOutput(HeatExchangerRecipesProvider.fluidToString(hots[j], true), amountBaseHot / amount[j]);
                recipe.offerTo(consumer, path);
            }
        }
    }
}

